/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatePartitionSequenceValue {
    YYYYMMDD("YYYYMMDD"),
    YYYYMMDDHH("YYYYMMDDHH"),
    YYYYMM("YYYYMM"),
    MMYYYYDD("MMYYYYDD"),
    DDMMYYYY("DDMMYYYY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatePartitionSequenceValue> VALUE_MAP;
    private final String value;

    private DatePartitionSequenceValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatePartitionSequenceValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatePartitionSequenceValue> knownValues() {
        EnumSet<DatePartitionSequenceValue> knownValues = EnumSet.allOf(DatePartitionSequenceValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatePartitionSequenceValue.class, DatePartitionSequenceValue::toString);
    }
}

