/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NeptuneSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NeptuneSettings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(NeptuneSettings.getter(NeptuneSettings::serviceAccessRoleArn)).setter(NeptuneSettings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(NeptuneSettings.getter(NeptuneSettings::s3BucketName)).setter(NeptuneSettings.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_BUCKET_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketFolder").getter(NeptuneSettings.getter(NeptuneSettings::s3BucketFolder)).setter(NeptuneSettings.setter(Builder::s3BucketFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketFolder").build()}).build();
    private static final SdkField<Integer> ERROR_RETRY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorRetryDuration").getter(NeptuneSettings.getter(NeptuneSettings::errorRetryDuration)).setter(NeptuneSettings.setter(Builder::errorRetryDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorRetryDuration").build()}).build();
    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFileSize").getter(NeptuneSettings.getter(NeptuneSettings::maxFileSize)).setter(NeptuneSettings.setter(Builder::maxFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()}).build();
    private static final SdkField<Integer> MAX_RETRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetryCount").getter(NeptuneSettings.getter(NeptuneSettings::maxRetryCount)).setter(NeptuneSettings.setter(Builder::maxRetryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetryCount").build()}).build();
    private static final SdkField<Boolean> IAM_AUTH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IamAuthEnabled").getter(NeptuneSettings.getter(NeptuneSettings::iamAuthEnabled)).setter(NeptuneSettings.setter(Builder::iamAuthEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamAuthEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD, S3_BUCKET_NAME_FIELD, S3_BUCKET_FOLDER_FIELD, ERROR_RETRY_DURATION_FIELD, MAX_FILE_SIZE_FIELD, MAX_RETRY_COUNT_FIELD, IAM_AUTH_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccessRoleArn;
    private final String s3BucketName;
    private final String s3BucketFolder;
    private final Integer errorRetryDuration;
    private final Integer maxFileSize;
    private final Integer maxRetryCount;
    private final Boolean iamAuthEnabled;

    private NeptuneSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketFolder = builder.s3BucketFolder;
        this.errorRetryDuration = builder.errorRetryDuration;
        this.maxFileSize = builder.maxFileSize;
        this.maxRetryCount = builder.maxRetryCount;
        this.iamAuthEnabled = builder.iamAuthEnabled;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3BucketFolder() {
        return this.s3BucketFolder;
    }

    public final Integer errorRetryDuration() {
        return this.errorRetryDuration;
    }

    public final Integer maxFileSize() {
        return this.maxFileSize;
    }

    public final Integer maxRetryCount() {
        return this.maxRetryCount;
    }

    public final Boolean iamAuthEnabled() {
        return this.iamAuthEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorRetryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamAuthEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeptuneSettings)) {
            return false;
        }
        NeptuneSettings other = (NeptuneSettings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3BucketFolder(), other.s3BucketFolder()) && Objects.equals(this.errorRetryDuration(), other.errorRetryDuration()) && Objects.equals(this.maxFileSize(), other.maxFileSize()) && Objects.equals(this.maxRetryCount(), other.maxRetryCount()) && Objects.equals(this.iamAuthEnabled(), other.iamAuthEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"NeptuneSettings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("S3BucketName", (Object)this.s3BucketName()).add("S3BucketFolder", (Object)this.s3BucketFolder()).add("ErrorRetryDuration", (Object)this.errorRetryDuration()).add("MaxFileSize", (Object)this.maxFileSize()).add("MaxRetryCount", (Object)this.maxRetryCount()).add("IamAuthEnabled", (Object)this.iamAuthEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3BucketFolder": {
                return Optional.ofNullable(clazz.cast(this.s3BucketFolder()));
            }
            case "ErrorRetryDuration": {
                return Optional.ofNullable(clazz.cast(this.errorRetryDuration()));
            }
            case "MaxFileSize": {
                return Optional.ofNullable(clazz.cast(this.maxFileSize()));
            }
            case "MaxRetryCount": {
                return Optional.ofNullable(clazz.cast(this.maxRetryCount()));
            }
            case "IamAuthEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamAuthEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NeptuneSettings, T> g) {
        return obj -> g.apply((NeptuneSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String s3BucketName;
        private String s3BucketFolder;
        private Integer errorRetryDuration;
        private Integer maxFileSize;
        private Integer maxRetryCount;
        private Boolean iamAuthEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneSettings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.s3BucketName(model.s3BucketName);
            this.s3BucketFolder(model.s3BucketFolder);
            this.errorRetryDuration(model.errorRetryDuration);
            this.maxFileSize(model.maxFileSize);
            this.maxRetryCount(model.maxRetryCount);
            this.iamAuthEnabled(model.iamAuthEnabled);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3BucketFolder() {
            return this.s3BucketFolder;
        }

        public final void setS3BucketFolder(String s3BucketFolder) {
            this.s3BucketFolder = s3BucketFolder;
        }

        @Override
        @Transient
        public final Builder s3BucketFolder(String s3BucketFolder) {
            this.s3BucketFolder = s3BucketFolder;
            return this;
        }

        public final Integer getErrorRetryDuration() {
            return this.errorRetryDuration;
        }

        public final void setErrorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
        }

        @Override
        @Transient
        public final Builder errorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
            return this;
        }

        public final Integer getMaxFileSize() {
            return this.maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        @Transient
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final Integer getMaxRetryCount() {
            return this.maxRetryCount;
        }

        public final void setMaxRetryCount(Integer maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
        }

        @Override
        @Transient
        public final Builder maxRetryCount(Integer maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
            return this;
        }

        public final Boolean getIamAuthEnabled() {
            return this.iamAuthEnabled;
        }

        public final void setIamAuthEnabled(Boolean iamAuthEnabled) {
            this.iamAuthEnabled = iamAuthEnabled;
        }

        @Override
        @Transient
        public final Builder iamAuthEnabled(Boolean iamAuthEnabled) {
            this.iamAuthEnabled = iamAuthEnabled;
            return this;
        }

        public NeptuneSettings build() {
            return new NeptuneSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NeptuneSettings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3BucketFolder(String var1);

        public Builder errorRetryDuration(Integer var1);

        public Builder maxFileSize(Integer var1);

        public Builder maxRetryCount(Integer var1);

        public Builder iamAuthEnabled(Boolean var1);
    }
}

