/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SafeguardPolicy {
    RELY_ON_SQL_SERVER_REPLICATION_AGENT("rely-on-sql-server-replication-agent"),
    EXCLUSIVE_AUTOMATIC_TRUNCATION("exclusive-automatic-truncation"),
    SHARED_AUTOMATIC_TRUNCATION("shared-automatic-truncation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SafeguardPolicy> VALUE_MAP;
    private final String value;

    private SafeguardPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SafeguardPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SafeguardPolicy> knownValues() {
        EnumSet<SafeguardPolicy> knownValues = EnumSet.allOf(SafeguardPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SafeguardPolicy.class, SafeguardPolicy::toString);
    }
}

