/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineDescription;
import software.amazon.awssdk.services.datapipeline.model.PipelineDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePipelinesResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, DescribePipelinesResponse> {
    private static final SdkField<List<PipelineDescription>> PIPELINE_DESCRIPTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineDescriptionList").getter(DescribePipelinesResponse.getter(DescribePipelinesResponse::pipelineDescriptionList)).setter(DescribePipelinesResponse.setter(Builder::pipelineDescriptionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineDescriptionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_DESCRIPTION_LIST_FIELD));
    private final List<PipelineDescription> pipelineDescriptionList;

    private DescribePipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineDescriptionList = builder.pipelineDescriptionList;
    }

    public final boolean hasPipelineDescriptionList() {
        return this.pipelineDescriptionList != null && !(this.pipelineDescriptionList instanceof SdkAutoConstructList);
    }

    public final List<PipelineDescription> pipelineDescriptionList() {
        return this.pipelineDescriptionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineDescriptionList() ? this.pipelineDescriptionList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelinesResponse)) {
            return false;
        }
        DescribePipelinesResponse other = (DescribePipelinesResponse)((Object)obj);
        return this.hasPipelineDescriptionList() == other.hasPipelineDescriptionList() && Objects.equals(this.pipelineDescriptionList(), other.pipelineDescriptionList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePipelinesResponse").add("PipelineDescriptionList", this.hasPipelineDescriptionList() ? this.pipelineDescriptionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineDescriptionList": {
                return Optional.ofNullable(clazz.cast(this.pipelineDescriptionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelinesResponse, T> g) {
        return obj -> g.apply((DescribePipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<PipelineDescription> pipelineDescriptionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelinesResponse model) {
            super(model);
            this.pipelineDescriptionList(model.pipelineDescriptionList);
        }

        public final List<PipelineDescription.Builder> getPipelineDescriptionList() {
            List<PipelineDescription.Builder> result = PipelineDescriptionListCopier.copyToBuilder(this.pipelineDescriptionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineDescriptionList(Collection<PipelineDescription.BuilderImpl> pipelineDescriptionList) {
            this.pipelineDescriptionList = PipelineDescriptionListCopier.copyFromBuilder(pipelineDescriptionList);
        }

        @Override
        @Transient
        public final Builder pipelineDescriptionList(Collection<PipelineDescription> pipelineDescriptionList) {
            this.pipelineDescriptionList = PipelineDescriptionListCopier.copy(pipelineDescriptionList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineDescriptionList(PipelineDescription ... pipelineDescriptionList) {
            this.pipelineDescriptionList(Arrays.asList(pipelineDescriptionList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineDescriptionList(Consumer<PipelineDescription.Builder> ... pipelineDescriptionList) {
            this.pipelineDescriptionList(Stream.of(pipelineDescriptionList).map(c -> (PipelineDescription)((PipelineDescription.Builder)PipelineDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePipelinesResponse build() {
            return new DescribePipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePipelinesResponse> {
        public Builder pipelineDescriptionList(Collection<PipelineDescription> var1);

        public Builder pipelineDescriptionList(PipelineDescription ... var1);

        public Builder pipelineDescriptionList(Consumer<PipelineDescription.Builder> ... var1);
    }
}

