/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.ResourceStatus;
import software.amazon.awssdk.services.inspector2.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Account
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Account> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(Account.getter(Account::accountId)).setter(Account.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<ResourceStatus> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceStatus").getter(Account.getter(Account::resourceStatus)).setter(Account.setter(Builder::resourceStatus)).constructor(ResourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceStatus").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Account.getter(Account::statusAsString)).setter(Account.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RESOURCE_STATUS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final ResourceStatus resourceStatus;
    private final String status;

    private Account(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.resourceStatus = builder.resourceStatus;
        this.status = builder.status;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ResourceStatus resourceStatus() {
        return this.resourceStatus;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceStatus(), other.resourceStatus()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Account").add("AccountId", (Object)this.accountId()).add("ResourceStatus", (Object)this.resourceStatus()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "resourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatus()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Account, T> g) {
        return obj -> g.apply((Account)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private ResourceStatus resourceStatus;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            this.accountId(model.accountId);
            this.resourceStatus(model.resourceStatus);
            this.status(model.status);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final ResourceStatus.Builder getResourceStatus() {
            return this.resourceStatus != null ? this.resourceStatus.toBuilder() : null;
        }

        public final void setResourceStatus(ResourceStatus.BuilderImpl resourceStatus) {
            this.resourceStatus = resourceStatus != null ? resourceStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Account build() {
            return new Account(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Account> {
        public Builder accountId(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        default public Builder resourceStatus(Consumer<ResourceStatus.Builder> resourceStatus) {
            return this.resourceStatus((ResourceStatus)((ResourceStatus.Builder)ResourceStatus.builder().applyMutation(resourceStatus)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

