/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AwsEcrContainerSortBy;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcrContainerAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcrContainerAggregation> {
    private static final SdkField<List<StringFilter>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("architectures").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::architectures)).setter(AwsEcrContainerAggregation.setter(Builder::architectures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> IMAGE_SHAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageShas").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::imageShas)).setter(AwsEcrContainerAggregation.setter(Builder::imageShas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageShas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTags").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::imageTags)).setter(AwsEcrContainerAggregation.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositories").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::repositories)).setter(AwsEcrContainerAggregation.setter(Builder::repositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIds").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::resourceIds)).setter(AwsEcrContainerAggregation.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::sortByAsString)).setter(AwsEcrContainerAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(AwsEcrContainerAggregation.getter(AwsEcrContainerAggregation::sortOrderAsString)).setter(AwsEcrContainerAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURES_FIELD, IMAGE_SHAS_FIELD, IMAGE_TAGS_FIELD, REPOSITORIES_FIELD, RESOURCE_IDS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> architectures;
    private final List<StringFilter> imageShas;
    private final List<StringFilter> imageTags;
    private final List<StringFilter> repositories;
    private final List<StringFilter> resourceIds;
    private final String sortBy;
    private final String sortOrder;

    private AwsEcrContainerAggregation(BuilderImpl builder) {
        this.architectures = builder.architectures;
        this.imageShas = builder.imageShas;
        this.imageTags = builder.imageTags;
        this.repositories = builder.repositories;
        this.resourceIds = builder.resourceIds;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> architectures() {
        return this.architectures;
    }

    public final boolean hasImageShas() {
        return this.imageShas != null && !(this.imageShas instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> imageShas() {
        return this.imageShas;
    }

    public final boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> imageTags() {
        return this.imageTags;
    }

    public final boolean hasRepositories() {
        return this.repositories != null && !(this.repositories instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> repositories() {
        return this.repositories;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> resourceIds() {
        return this.resourceIds;
    }

    public final AwsEcrContainerSortBy sortBy() {
        return AwsEcrContainerSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageShas() ? this.imageShas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositories() ? this.repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerAggregation)) {
            return false;
        }
        AwsEcrContainerAggregation other = (AwsEcrContainerAggregation)obj;
        return this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architectures(), other.architectures()) && this.hasImageShas() == other.hasImageShas() && Objects.equals(this.imageShas(), other.imageShas()) && this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && this.hasRepositories() == other.hasRepositories() && Objects.equals(this.repositories(), other.repositories()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcrContainerAggregation").add("Architectures", this.hasArchitectures() ? this.architectures() : null).add("ImageShas", this.hasImageShas() ? this.imageShas() : null).add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("Repositories", this.hasRepositories() ? this.repositories() : null).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "architectures": {
                return Optional.ofNullable(clazz.cast(this.architectures()));
            }
            case "imageShas": {
                return Optional.ofNullable(clazz.cast(this.imageShas()));
            }
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "repositories": {
                return Optional.ofNullable(clazz.cast(this.repositories()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerAggregation, T> g) {
        return obj -> g.apply((AwsEcrContainerAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> architectures = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> imageShas = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> imageTags = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> repositories = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerAggregation model) {
            this.architectures(model.architectures);
            this.imageShas(model.imageShas);
            this.imageTags(model.imageTags);
            this.repositories(model.repositories);
            this.resourceIds(model.resourceIds);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getArchitectures() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.architectures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArchitectures(Collection<StringFilter.BuilderImpl> architectures) {
            this.architectures = StringFilterListCopier.copyFromBuilder(architectures);
        }

        @Override
        @Transient
        public final Builder architectures(Collection<StringFilter> architectures) {
            this.architectures = StringFilterListCopier.copy(architectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectures(StringFilter ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectures(Consumer<StringFilter.Builder> ... architectures) {
            this.architectures(Stream.of(architectures).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getImageShas() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.imageShas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageShas(Collection<StringFilter.BuilderImpl> imageShas) {
            this.imageShas = StringFilterListCopier.copyFromBuilder(imageShas);
        }

        @Override
        @Transient
        public final Builder imageShas(Collection<StringFilter> imageShas) {
            this.imageShas = StringFilterListCopier.copy(imageShas);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageShas(StringFilter ... imageShas) {
            this.imageShas(Arrays.asList(imageShas));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageShas(Consumer<StringFilter.Builder> ... imageShas) {
            this.imageShas(Stream.of(imageShas).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getImageTags() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.imageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageTags(Collection<StringFilter.BuilderImpl> imageTags) {
            this.imageTags = StringFilterListCopier.copyFromBuilder(imageTags);
        }

        @Override
        @Transient
        public final Builder imageTags(Collection<StringFilter> imageTags) {
            this.imageTags = StringFilterListCopier.copy(imageTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageTags(StringFilter ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageTags(Consumer<StringFilter.Builder> ... imageTags) {
            this.imageTags(Stream.of(imageTags).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRepositories() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<StringFilter.BuilderImpl> repositories) {
            this.repositories = StringFilterListCopier.copyFromBuilder(repositories);
        }

        @Override
        @Transient
        public final Builder repositories(Collection<StringFilter> repositories) {
            this.repositories = StringFilterListCopier.copy(repositories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder repositories(StringFilter ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder repositories(Consumer<StringFilter.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        @Transient
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceIds(StringFilter ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder> ... resourceIds) {
            this.resourceIds(Stream.of(resourceIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Transient
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Transient
        public final Builder sortBy(AwsEcrContainerSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        @Transient
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public AwsEcrContainerAggregation build() {
            return new AwsEcrContainerAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcrContainerAggregation> {
        public Builder architectures(Collection<StringFilter> var1);

        public Builder architectures(StringFilter ... var1);

        public Builder architectures(Consumer<StringFilter.Builder> ... var1);

        public Builder imageShas(Collection<StringFilter> var1);

        public Builder imageShas(StringFilter ... var1);

        public Builder imageShas(Consumer<StringFilter.Builder> ... var1);

        public Builder imageTags(Collection<StringFilter> var1);

        public Builder imageTags(StringFilter ... var1);

        public Builder imageTags(Consumer<StringFilter.Builder> ... var1);

        public Builder repositories(Collection<StringFilter> var1);

        public Builder repositories(StringFilter ... var1);

        public Builder repositories(Consumer<StringFilter.Builder> ... var1);

        public Builder resourceIds(Collection<StringFilter> var1);

        public Builder resourceIds(StringFilter ... var1);

        public Builder resourceIds(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(AwsEcrContainerSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

