/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.FindingStatus;
import software.amazon.awssdk.services.inspector2.model.FindingType;
import software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails;
import software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails;
import software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails;
import software.amazon.awssdk.services.inspector2.model.Remediation;
import software.amazon.awssdk.services.inspector2.model.Resource;
import software.amazon.awssdk.services.inspector2.model.ResourceListCopier;
import software.amazon.awssdk.services.inspector2.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Finding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Finding> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(Finding.getter(Finding::awsAccountId)).setter(Finding.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Finding.getter(Finding::description)).setter(Finding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingArn").getter(Finding.getter(Finding::findingArn)).setter(Finding.setter(Builder::findingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()}).build();
    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstObservedAt").getter(Finding.getter(Finding::firstObservedAt)).setter(Finding.setter(Builder::firstObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()}).build();
    private static final SdkField<Double> INSPECTOR_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("inspectorScore").getter(Finding.getter(Finding::inspectorScore)).setter(Finding.setter(Builder::inspectorScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScore").build()}).build();
    private static final SdkField<InspectorScoreDetails> INSPECTOR_SCORE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inspectorScoreDetails").getter(Finding.getter(Finding::inspectorScoreDetails)).setter(Finding.setter(Builder::inspectorScoreDetails)).constructor(InspectorScoreDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScoreDetails").build()}).build();
    private static final SdkField<Instant> LAST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastObservedAt").getter(Finding.getter(Finding::lastObservedAt)).setter(Finding.setter(Builder::lastObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastObservedAt").build()}).build();
    private static final SdkField<NetworkReachabilityDetails> NETWORK_REACHABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkReachabilityDetails").getter(Finding.getter(Finding::networkReachabilityDetails)).setter(Finding.setter(Builder::networkReachabilityDetails)).constructor(NetworkReachabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkReachabilityDetails").build()}).build();
    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageVulnerabilityDetails").getter(Finding.getter(Finding::packageVulnerabilityDetails)).setter(Finding.setter(Builder::packageVulnerabilityDetails)).constructor(PackageVulnerabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails").build()}).build();
    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remediation").getter(Finding.getter(Finding::remediation)).setter(Finding.setter(Builder::remediation)).constructor(Remediation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(Finding.getter(Finding::resources)).setter(Finding.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(Finding.getter(Finding::severityAsString)).setter(Finding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Finding.getter(Finding::statusAsString)).setter(Finding.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Finding.getter(Finding::title)).setter(Finding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Finding.getter(Finding::typeAsString)).setter(Finding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Finding.getter(Finding::updatedAt)).setter(Finding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD, FINDING_ARN_FIELD, FIRST_OBSERVED_AT_FIELD, INSPECTOR_SCORE_FIELD, INSPECTOR_SCORE_DETAILS_FIELD, LAST_OBSERVED_AT_FIELD, NETWORK_REACHABILITY_DETAILS_FIELD, PACKAGE_VULNERABILITY_DETAILS_FIELD, REMEDIATION_FIELD, RESOURCES_FIELD, SEVERITY_FIELD, STATUS_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String description;
    private final String findingArn;
    private final Instant firstObservedAt;
    private final Double inspectorScore;
    private final InspectorScoreDetails inspectorScoreDetails;
    private final Instant lastObservedAt;
    private final NetworkReachabilityDetails networkReachabilityDetails;
    private final PackageVulnerabilityDetails packageVulnerabilityDetails;
    private final Remediation remediation;
    private final List<Resource> resources;
    private final String severity;
    private final String status;
    private final String title;
    private final String type;
    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.description = builder.description;
        this.findingArn = builder.findingArn;
        this.firstObservedAt = builder.firstObservedAt;
        this.inspectorScore = builder.inspectorScore;
        this.inspectorScoreDetails = builder.inspectorScoreDetails;
        this.lastObservedAt = builder.lastObservedAt;
        this.networkReachabilityDetails = builder.networkReachabilityDetails;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.remediation = builder.remediation;
        this.resources = builder.resources;
        this.severity = builder.severity;
        this.status = builder.status;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String description() {
        return this.description;
    }

    public final String findingArn() {
        return this.findingArn;
    }

    public final Instant firstObservedAt() {
        return this.firstObservedAt;
    }

    public final Double inspectorScore() {
        return this.inspectorScore;
    }

    public final InspectorScoreDetails inspectorScoreDetails() {
        return this.inspectorScoreDetails;
    }

    public final Instant lastObservedAt() {
        return this.lastObservedAt;
    }

    public final NetworkReachabilityDetails networkReachabilityDetails() {
        return this.networkReachabilityDetails;
    }

    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return this.packageVulnerabilityDetails;
    }

    public final Remediation remediation() {
        return this.remediation;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String title() {
        return this.title;
    }

    public final FindingType type() {
        return FindingType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectorScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectorScoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkReachabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.findingArn(), other.findingArn()) && Objects.equals(this.firstObservedAt(), other.firstObservedAt()) && Objects.equals(this.inspectorScore(), other.inspectorScore()) && Objects.equals(this.inspectorScoreDetails(), other.inspectorScoreDetails()) && Objects.equals(this.lastObservedAt(), other.lastObservedAt()) && Objects.equals(this.networkReachabilityDetails(), other.networkReachabilityDetails()) && Objects.equals(this.packageVulnerabilityDetails(), other.packageVulnerabilityDetails()) && Objects.equals(this.remediation(), other.remediation()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Finding").add("AwsAccountId", (Object)this.awsAccountId()).add("Description", (Object)this.description()).add("FindingArn", (Object)this.findingArn()).add("FirstObservedAt", (Object)this.firstObservedAt()).add("InspectorScore", (Object)this.inspectorScore()).add("InspectorScoreDetails", (Object)this.inspectorScoreDetails()).add("LastObservedAt", (Object)this.lastObservedAt()).add("NetworkReachabilityDetails", (Object)this.networkReachabilityDetails()).add("PackageVulnerabilityDetails", (Object)this.packageVulnerabilityDetails()).add("Remediation", (Object)this.remediation()).add("Resources", this.hasResources() ? this.resources() : null).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("Title", (Object)this.title()).add("Type", (Object)this.typeAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "findingArn": {
                return Optional.ofNullable(clazz.cast(this.findingArn()));
            }
            case "firstObservedAt": {
                return Optional.ofNullable(clazz.cast(this.firstObservedAt()));
            }
            case "inspectorScore": {
                return Optional.ofNullable(clazz.cast(this.inspectorScore()));
            }
            case "inspectorScoreDetails": {
                return Optional.ofNullable(clazz.cast(this.inspectorScoreDetails()));
            }
            case "lastObservedAt": {
                return Optional.ofNullable(clazz.cast(this.lastObservedAt()));
            }
            case "networkReachabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.networkReachabilityDetails()));
            }
            case "packageVulnerabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.packageVulnerabilityDetails()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String description;
        private String findingArn;
        private Instant firstObservedAt;
        private Double inspectorScore;
        private InspectorScoreDetails inspectorScoreDetails;
        private Instant lastObservedAt;
        private NetworkReachabilityDetails networkReachabilityDetails;
        private PackageVulnerabilityDetails packageVulnerabilityDetails;
        private Remediation remediation;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private String severity;
        private String status;
        private String title;
        private String type;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.awsAccountId(model.awsAccountId);
            this.description(model.description);
            this.findingArn(model.findingArn);
            this.firstObservedAt(model.firstObservedAt);
            this.inspectorScore(model.inspectorScore);
            this.inspectorScoreDetails(model.inspectorScoreDetails);
            this.lastObservedAt(model.lastObservedAt);
            this.networkReachabilityDetails(model.networkReachabilityDetails);
            this.packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            this.remediation(model.remediation);
            this.resources(model.resources);
            this.severity(model.severity);
            this.status(model.status);
            this.title(model.title);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFindingArn() {
            return this.findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        @Transient
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Instant getFirstObservedAt() {
            return this.firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        @Transient
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final Double getInspectorScore() {
            return this.inspectorScore;
        }

        public final void setInspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
        }

        @Override
        @Transient
        public final Builder inspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
            return this;
        }

        public final InspectorScoreDetails.Builder getInspectorScoreDetails() {
            return this.inspectorScoreDetails != null ? this.inspectorScoreDetails.toBuilder() : null;
        }

        public final void setInspectorScoreDetails(InspectorScoreDetails.BuilderImpl inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails != null ? inspectorScoreDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails;
            return this;
        }

        public final Instant getLastObservedAt() {
            return this.lastObservedAt;
        }

        public final void setLastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        @Transient
        public final Builder lastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final NetworkReachabilityDetails.Builder getNetworkReachabilityDetails() {
            return this.networkReachabilityDetails != null ? this.networkReachabilityDetails.toBuilder() : null;
        }

        public final void setNetworkReachabilityDetails(NetworkReachabilityDetails.BuilderImpl networkReachabilityDetails) {
            this.networkReachabilityDetails = networkReachabilityDetails != null ? networkReachabilityDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder networkReachabilityDetails(NetworkReachabilityDetails networkReachabilityDetails) {
            this.networkReachabilityDetails = networkReachabilityDetails;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return this.packageVulnerabilityDetails != null ? this.packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return this.remediation != null ? this.remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        @Transient
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        @Transient
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(FindingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Finding build() {
            return new Finding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Finding> {
        public Builder awsAccountId(String var1);

        public Builder description(String var1);

        public Builder findingArn(String var1);

        public Builder firstObservedAt(Instant var1);

        public Builder inspectorScore(Double var1);

        public Builder inspectorScoreDetails(InspectorScoreDetails var1);

        default public Builder inspectorScoreDetails(Consumer<InspectorScoreDetails.Builder> inspectorScoreDetails) {
            return this.inspectorScoreDetails((InspectorScoreDetails)((InspectorScoreDetails.Builder)InspectorScoreDetails.builder().applyMutation(inspectorScoreDetails)).build());
        }

        public Builder lastObservedAt(Instant var1);

        public Builder networkReachabilityDetails(NetworkReachabilityDetails var1);

        default public Builder networkReachabilityDetails(Consumer<NetworkReachabilityDetails.Builder> networkReachabilityDetails) {
            return this.networkReachabilityDetails((NetworkReachabilityDetails)((NetworkReachabilityDetails.Builder)NetworkReachabilityDetails.builder().applyMutation(networkReachabilityDetails)).build());
        }

        public Builder packageVulnerabilityDetails(PackageVulnerabilityDetails var1);

        default public Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return this.packageVulnerabilityDetails((PackageVulnerabilityDetails)((PackageVulnerabilityDetails.Builder)PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)).build());
        }

        public Builder remediation(Remediation var1);

        default public Builder remediation(Consumer<Remediation.Builder> remediation) {
            return this.remediation((Remediation)((Remediation.Builder)Remediation.builder().applyMutation(remediation)).build());
        }

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder title(String var1);

        public Builder type(String var1);

        public Builder type(FindingType var1);

        public Builder updatedAt(Instant var1);
    }
}

