/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.UsageTotal;
import software.amazon.awssdk.services.inspector2.model.UsageTotalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsageTotalsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListUsageTotalsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUsageTotalsResponse.getter(ListUsageTotalsResponse::nextToken)).setter(ListUsageTotalsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<UsageTotal>> TOTALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("totals").getter(ListUsageTotalsResponse.getter(ListUsageTotalsResponse::totals)).setter(ListUsageTotalsResponse.setter(Builder::totals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageTotal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TOTALS_FIELD));
    private final String nextToken;
    private final List<UsageTotal> totals;

    private ListUsageTotalsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.totals = builder.totals;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTotals() {
        return this.totals != null && !(this.totals instanceof SdkAutoConstructList);
    }

    public final List<UsageTotal> totals() {
        return this.totals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTotals() ? this.totals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageTotalsResponse)) {
            return false;
        }
        ListUsageTotalsResponse other = (ListUsageTotalsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTotals() == other.hasTotals() && Objects.equals(this.totals(), other.totals());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsageTotalsResponse").add("NextToken", (Object)this.nextToken()).add("Totals", this.hasTotals() ? this.totals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "totals": {
                return Optional.ofNullable(clazz.cast(this.totals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsageTotalsResponse, T> g) {
        return obj -> g.apply((ListUsageTotalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UsageTotal> totals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsageTotalsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.totals(model.totals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UsageTotal.Builder> getTotals() {
            List<UsageTotal.Builder> result = UsageTotalListCopier.copyToBuilder(this.totals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTotals(Collection<UsageTotal.BuilderImpl> totals) {
            this.totals = UsageTotalListCopier.copyFromBuilder(totals);
        }

        @Override
        @Transient
        public final Builder totals(Collection<UsageTotal> totals) {
            this.totals = UsageTotalListCopier.copy(totals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder totals(UsageTotal ... totals) {
            this.totals(Arrays.asList(totals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder totals(Consumer<UsageTotal.Builder> ... totals) {
            this.totals(Stream.of(totals).map(c -> (UsageTotal)((UsageTotal.Builder)UsageTotal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUsageTotalsResponse build() {
            return new ListUsageTotalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsageTotalsResponse> {
        public Builder nextToken(String var1);

        public Builder totals(Collection<UsageTotal> var1);

        public Builder totals(UsageTotal ... var1);

        public Builder totals(Consumer<UsageTotal.Builder> ... var1);
    }
}

