/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceStatus> {
    private static final SdkField<String> EC2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2").getter(ResourceStatus.getter(ResourceStatus::ec2AsString)).setter(ResourceStatus.setter(Builder::ec2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()}).build();
    private static final SdkField<String> ECR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecr").getter(ResourceStatus.getter(ResourceStatus::ecrAsString)).setter(ResourceStatus.setter(Builder::ecr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ec2;
    private final String ecr;

    private ResourceStatus(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
    }

    public final Status ec2() {
        return Status.fromValue(this.ec2);
    }

    public final String ec2AsString() {
        return this.ec2;
    }

    public final Status ecr() {
        return Status.fromValue(this.ecr);
    }

    public final String ecrAsString() {
        return this.ecr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatus)) {
            return false;
        }
        ResourceStatus other = (ResourceStatus)obj;
        return Objects.equals(this.ec2AsString(), other.ec2AsString()) && Objects.equals(this.ecrAsString(), other.ecrAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceStatus").add("Ec2", (Object)this.ec2AsString()).add("Ecr", (Object)this.ecrAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2": {
                return Optional.ofNullable(clazz.cast(this.ec2AsString()));
            }
            case "ecr": {
                return Optional.ofNullable(clazz.cast(this.ecrAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatus, T> g) {
        return obj -> g.apply((ResourceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2;
        private String ecr;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatus model) {
            this.ec2(model.ec2);
            this.ecr(model.ecr);
        }

        public final String getEc2() {
            return this.ec2;
        }

        public final void setEc2(String ec2) {
            this.ec2 = ec2;
        }

        @Override
        @Transient
        public final Builder ec2(String ec2) {
            this.ec2 = ec2;
            return this;
        }

        @Override
        @Transient
        public final Builder ec2(Status ec2) {
            this.ec2(ec2 == null ? null : ec2.toString());
            return this;
        }

        public final String getEcr() {
            return this.ecr;
        }

        public final void setEcr(String ecr) {
            this.ecr = ecr;
        }

        @Override
        @Transient
        public final Builder ecr(String ecr) {
            this.ecr = ecr;
            return this;
        }

        @Override
        @Transient
        public final Builder ecr(Status ecr) {
            this.ecr(ecr == null ? null : ecr.toString());
            return this;
        }

        public ResourceStatus build() {
            return new ResourceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceStatus> {
        public Builder ec2(String var1);

        public Builder ec2(Status var1);

        public Builder ecr(String var1);

        public Builder ecr(Status var1);
    }
}

