/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.ScanStatusCode;
import software.amazon.awssdk.services.inspector2.model.ScanStatusReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanStatus> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ScanStatus.getter(ScanStatus::reasonAsString)).setter(ScanStatus.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(ScanStatus.getter(ScanStatus::statusCodeAsString)).setter(ScanStatus.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, STATUS_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final String statusCodeValue;

    private ScanStatus(BuilderImpl builder) {
        this.reason = builder.reason;
        this.statusCodeValue = builder.statusCodeValue;
    }

    public final ScanStatusReason reason() {
        return ScanStatusReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final ScanStatusCode statusCode() {
        return ScanStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanStatus)) {
            return false;
        }
        ScanStatus other = (ScanStatus)obj;
        return Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScanStatus").add("Reason", (Object)this.reasonAsString()).add("StatusCode", (Object)this.statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanStatus, T> g) {
        return obj -> g.apply((ScanStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reason;
        private String statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanStatus model) {
            this.reason(model.reason);
            this.statusCode(model.statusCodeValue);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        @Transient
        public final Builder reason(ScanStatusReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(ScanStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public ScanStatus build() {
            return new ScanStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanStatus> {
        public Builder reason(String var1);

        public Builder reason(ScanStatusReason var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ScanStatusCode var1);
    }
}

