/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.StringComparison;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringFilter> {
    private static final SdkField<String> COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comparison").getter(StringFilter.getter(StringFilter::comparisonAsString)).setter(StringFilter.setter(Builder::comparison)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparison").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(StringFilter.getter(StringFilter::value)).setter(StringFilter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparison;
    private final String value;

    private StringFilter(BuilderImpl builder) {
        this.comparison = builder.comparison;
        this.value = builder.value;
    }

    public final StringComparison comparison() {
        return StringComparison.fromValue(this.comparison);
    }

    public final String comparisonAsString() {
        return this.comparison;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringFilter)) {
            return false;
        }
        StringFilter other = (StringFilter)obj;
        return Objects.equals(this.comparisonAsString(), other.comparisonAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"StringFilter").add("Comparison", (Object)this.comparisonAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparison": {
                return Optional.ofNullable(clazz.cast(this.comparisonAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringFilter, T> g) {
        return obj -> g.apply((StringFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparison;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(StringFilter model) {
            this.comparison(model.comparison);
            this.value(model.value);
        }

        public final String getComparison() {
            return this.comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        @Transient
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        @Transient
        public final Builder comparison(StringComparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public StringFilter build() {
            return new StringFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringFilter> {
        public Builder comparison(String var1);

        public Builder comparison(StringComparison var1);

        public Builder value(String var1);
    }
}

