/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CannedAccessControlList {
    PRIVATE("private"),
    PUBLIC_READ("public-read"),
    PUBLIC_READ_WRITE("public-read-write"),
    AWS_EXEC_READ("aws-exec-read"),
    AUTHENTICATED_READ("authenticated-read"),
    BUCKET_OWNER_READ("bucket-owner-read"),
    BUCKET_OWNER_FULL_CONTROL("bucket-owner-full-control"),
    LOG_DELIVERY_WRITE("log-delivery-write"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CannedAccessControlList(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CannedAccessControlList fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CannedAccessControlList.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CannedAccessControlList> knownValues() {
        return Stream.of(CannedAccessControlList.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

