/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatistics;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget;
import software.amazon.awssdk.services.iot.model.MitigationAction;
import software.amazon.awssdk.services.iot.model.MitigationActionListCopier;
import software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectMitigationActionsTaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectMitigationActionsTaskSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::taskId)).setter(DetectMitigationActionsTaskSummary.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStatus").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::taskStatusAsString)).setter(DetectMitigationActionsTaskSummary.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()}).build();
    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("taskStartTime").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::taskStartTime)).setter(DetectMitigationActionsTaskSummary.setter(Builder::taskStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build()}).build();
    private static final SdkField<Instant> TASK_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("taskEndTime").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::taskEndTime)).setter(DetectMitigationActionsTaskSummary.setter(Builder::taskEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskEndTime").build()}).build();
    private static final SdkField<DetectMitigationActionsTaskTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::target)).setter(DetectMitigationActionsTaskSummary.setter(Builder::target)).constructor(DetectMitigationActionsTaskTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<ViolationEventOccurrenceRange> VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("violationEventOccurrenceRange").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::violationEventOccurrenceRange)).setter(DetectMitigationActionsTaskSummary.setter(Builder::violationEventOccurrenceRange)).constructor(ViolationEventOccurrenceRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventOccurrenceRange").build()}).build();
    private static final SdkField<Boolean> ONLY_ACTIVE_VIOLATIONS_INCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("onlyActiveViolationsIncluded").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::onlyActiveViolationsIncluded)).setter(DetectMitigationActionsTaskSummary.setter(Builder::onlyActiveViolationsIncluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlyActiveViolationsIncluded").build()}).build();
    private static final SdkField<Boolean> SUPPRESSED_ALERTS_INCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suppressedAlertsIncluded").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::suppressedAlertsIncluded)).setter(DetectMitigationActionsTaskSummary.setter(Builder::suppressedAlertsIncluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressedAlertsIncluded").build()}).build();
    private static final SdkField<List<MitigationAction>> ACTIONS_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionsDefinition").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::actionsDefinition)).setter(DetectMitigationActionsTaskSummary.setter(Builder::actionsDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsDefinition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MitigationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DetectMitigationActionsTaskStatistics> TASK_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskStatistics").getter(DetectMitigationActionsTaskSummary.getter(DetectMitigationActionsTaskSummary::taskStatistics)).setter(DetectMitigationActionsTaskSummary.setter(Builder::taskStatistics)).constructor(DetectMitigationActionsTaskStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_STATUS_FIELD, TASK_START_TIME_FIELD, TASK_END_TIME_FIELD, TARGET_FIELD, VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD, ONLY_ACTIVE_VIOLATIONS_INCLUDED_FIELD, SUPPRESSED_ALERTS_INCLUDED_FIELD, ACTIONS_DEFINITION_FIELD, TASK_STATISTICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String taskStatus;
    private final Instant taskStartTime;
    private final Instant taskEndTime;
    private final DetectMitigationActionsTaskTarget target;
    private final ViolationEventOccurrenceRange violationEventOccurrenceRange;
    private final Boolean onlyActiveViolationsIncluded;
    private final Boolean suppressedAlertsIncluded;
    private final List<MitigationAction> actionsDefinition;
    private final DetectMitigationActionsTaskStatistics taskStatistics;

    private DetectMitigationActionsTaskSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.taskStartTime = builder.taskStartTime;
        this.taskEndTime = builder.taskEndTime;
        this.target = builder.target;
        this.violationEventOccurrenceRange = builder.violationEventOccurrenceRange;
        this.onlyActiveViolationsIncluded = builder.onlyActiveViolationsIncluded;
        this.suppressedAlertsIncluded = builder.suppressedAlertsIncluded;
        this.actionsDefinition = builder.actionsDefinition;
        this.taskStatistics = builder.taskStatistics;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final DetectMitigationActionsTaskStatus taskStatus() {
        return DetectMitigationActionsTaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final Instant taskStartTime() {
        return this.taskStartTime;
    }

    public final Instant taskEndTime() {
        return this.taskEndTime;
    }

    public final DetectMitigationActionsTaskTarget target() {
        return this.target;
    }

    public final ViolationEventOccurrenceRange violationEventOccurrenceRange() {
        return this.violationEventOccurrenceRange;
    }

    public final Boolean onlyActiveViolationsIncluded() {
        return this.onlyActiveViolationsIncluded;
    }

    public final Boolean suppressedAlertsIncluded() {
        return this.suppressedAlertsIncluded;
    }

    public final boolean hasActionsDefinition() {
        return this.actionsDefinition != null && !(this.actionsDefinition instanceof SdkAutoConstructList);
    }

    public final List<MitigationAction> actionsDefinition() {
        return this.actionsDefinition;
    }

    public final DetectMitigationActionsTaskStatistics taskStatistics() {
        return this.taskStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventOccurrenceRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlyActiveViolationsIncluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedAlertsIncluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionsDefinition() ? this.actionsDefinition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionsTaskSummary)) {
            return false;
        }
        DetectMitigationActionsTaskSummary other = (DetectMitigationActionsTaskSummary)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.taskEndTime(), other.taskEndTime()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.violationEventOccurrenceRange(), other.violationEventOccurrenceRange()) && Objects.equals(this.onlyActiveViolationsIncluded(), other.onlyActiveViolationsIncluded()) && Objects.equals(this.suppressedAlertsIncluded(), other.suppressedAlertsIncluded()) && this.hasActionsDefinition() == other.hasActionsDefinition() && Objects.equals(this.actionsDefinition(), other.actionsDefinition()) && Objects.equals(this.taskStatistics(), other.taskStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"DetectMitigationActionsTaskSummary").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("TaskStartTime", (Object)this.taskStartTime()).add("TaskEndTime", (Object)this.taskEndTime()).add("Target", (Object)this.target()).add("ViolationEventOccurrenceRange", (Object)this.violationEventOccurrenceRange()).add("OnlyActiveViolationsIncluded", (Object)this.onlyActiveViolationsIncluded()).add("SuppressedAlertsIncluded", (Object)this.suppressedAlertsIncluded()).add("ActionsDefinition", this.hasActionsDefinition() ? this.actionsDefinition() : null).add("TaskStatistics", (Object)this.taskStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "taskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "taskEndTime": {
                return Optional.ofNullable(clazz.cast(this.taskEndTime()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "violationEventOccurrenceRange": {
                return Optional.ofNullable(clazz.cast(this.violationEventOccurrenceRange()));
            }
            case "onlyActiveViolationsIncluded": {
                return Optional.ofNullable(clazz.cast(this.onlyActiveViolationsIncluded()));
            }
            case "suppressedAlertsIncluded": {
                return Optional.ofNullable(clazz.cast(this.suppressedAlertsIncluded()));
            }
            case "actionsDefinition": {
                return Optional.ofNullable(clazz.cast(this.actionsDefinition()));
            }
            case "taskStatistics": {
                return Optional.ofNullable(clazz.cast(this.taskStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionsTaskSummary, T> g) {
        return obj -> g.apply((DetectMitigationActionsTaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private Instant taskStartTime;
        private Instant taskEndTime;
        private DetectMitigationActionsTaskTarget target;
        private ViolationEventOccurrenceRange violationEventOccurrenceRange;
        private Boolean onlyActiveViolationsIncluded;
        private Boolean suppressedAlertsIncluded;
        private List<MitigationAction> actionsDefinition = DefaultSdkAutoConstructList.getInstance();
        private DetectMitigationActionsTaskStatistics taskStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionsTaskSummary model) {
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.taskStartTime(model.taskStartTime);
            this.taskEndTime(model.taskEndTime);
            this.target(model.target);
            this.violationEventOccurrenceRange(model.violationEventOccurrenceRange);
            this.onlyActiveViolationsIncluded(model.onlyActiveViolationsIncluded);
            this.suppressedAlertsIncluded(model.suppressedAlertsIncluded);
            this.actionsDefinition(model.actionsDefinition);
            this.taskStatistics(model.taskStatistics);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(DetectMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final Instant getTaskEndTime() {
            return this.taskEndTime;
        }

        @Override
        public final Builder taskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
            return this;
        }

        public final void setTaskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        public final DetectMitigationActionsTaskTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(DetectMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(DetectMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final ViolationEventOccurrenceRange.Builder getViolationEventOccurrenceRange() {
            return this.violationEventOccurrenceRange != null ? this.violationEventOccurrenceRange.toBuilder() : null;
        }

        @Override
        public final Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange;
            return this;
        }

        public final void setViolationEventOccurrenceRange(ViolationEventOccurrenceRange.BuilderImpl violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange != null ? violationEventOccurrenceRange.build() : null;
        }

        public final Boolean getOnlyActiveViolationsIncluded() {
            return this.onlyActiveViolationsIncluded;
        }

        @Override
        public final Builder onlyActiveViolationsIncluded(Boolean onlyActiveViolationsIncluded) {
            this.onlyActiveViolationsIncluded = onlyActiveViolationsIncluded;
            return this;
        }

        public final void setOnlyActiveViolationsIncluded(Boolean onlyActiveViolationsIncluded) {
            this.onlyActiveViolationsIncluded = onlyActiveViolationsIncluded;
        }

        public final Boolean getSuppressedAlertsIncluded() {
            return this.suppressedAlertsIncluded;
        }

        @Override
        public final Builder suppressedAlertsIncluded(Boolean suppressedAlertsIncluded) {
            this.suppressedAlertsIncluded = suppressedAlertsIncluded;
            return this;
        }

        public final void setSuppressedAlertsIncluded(Boolean suppressedAlertsIncluded) {
            this.suppressedAlertsIncluded = suppressedAlertsIncluded;
        }

        public final Collection<MitigationAction.Builder> getActionsDefinition() {
            if (this.actionsDefinition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionsDefinition != null ? (Collection)this.actionsDefinition.stream().map(MitigationAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionsDefinition(Collection<MitigationAction> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copy(actionsDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(MitigationAction ... actionsDefinition) {
            this.actionsDefinition(Arrays.asList(actionsDefinition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(Consumer<MitigationAction.Builder> ... actionsDefinition) {
            this.actionsDefinition(Stream.of(actionsDefinition).map(c -> (MitigationAction)((MitigationAction.Builder)MitigationAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionsDefinition(Collection<MitigationAction.BuilderImpl> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copyFromBuilder(actionsDefinition);
        }

        public final DetectMitigationActionsTaskStatistics.Builder getTaskStatistics() {
            return this.taskStatistics != null ? this.taskStatistics.toBuilder() : null;
        }

        @Override
        public final Builder taskStatistics(DetectMitigationActionsTaskStatistics taskStatistics) {
            this.taskStatistics = taskStatistics;
            return this;
        }

        public final void setTaskStatistics(DetectMitigationActionsTaskStatistics.BuilderImpl taskStatistics) {
            this.taskStatistics = taskStatistics != null ? taskStatistics.build() : null;
        }

        public DetectMitigationActionsTaskSummary build() {
            return new DetectMitigationActionsTaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectMitigationActionsTaskSummary> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(DetectMitigationActionsTaskStatus var1);

        public Builder taskStartTime(Instant var1);

        public Builder taskEndTime(Instant var1);

        public Builder target(DetectMitigationActionsTaskTarget var1);

        default public Builder target(Consumer<DetectMitigationActionsTaskTarget.Builder> target) {
            return this.target((DetectMitigationActionsTaskTarget)((DetectMitigationActionsTaskTarget.Builder)DetectMitigationActionsTaskTarget.builder().applyMutation(target)).build());
        }

        public Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange var1);

        default public Builder violationEventOccurrenceRange(Consumer<ViolationEventOccurrenceRange.Builder> violationEventOccurrenceRange) {
            return this.violationEventOccurrenceRange((ViolationEventOccurrenceRange)((ViolationEventOccurrenceRange.Builder)ViolationEventOccurrenceRange.builder().applyMutation(violationEventOccurrenceRange)).build());
        }

        public Builder onlyActiveViolationsIncluded(Boolean var1);

        public Builder suppressedAlertsIncluded(Boolean var1);

        public Builder actionsDefinition(Collection<MitigationAction> var1);

        public Builder actionsDefinition(MitigationAction ... var1);

        public Builder actionsDefinition(Consumer<MitigationAction.Builder> ... var1);

        public Builder taskStatistics(DetectMitigationActionsTaskStatistics var1);

        default public Builder taskStatistics(Consumer<DetectMitigationActionsTaskStatistics.Builder> taskStatistics) {
            return this.taskStatistics((DetectMitigationActionsTaskStatistics)((DetectMitigationActionsTaskStatistics.Builder)DetectMitigationActionsTaskStatistics.builder().applyMutation(taskStatistics)).build());
        }
    }
}

