/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ActiveViolation;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;

public class ListActiveViolationsPublisher
implements SdkPublisher<ListActiveViolationsResponse> {
    private final IotAsyncClient client;
    private final ListActiveViolationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActiveViolationsPublisher(IotAsyncClient client, ListActiveViolationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActiveViolationsPublisher(IotAsyncClient client, ListActiveViolationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActiveViolationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActiveViolationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActiveViolation> activeViolations() {
        Function<ListActiveViolationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activeViolations() != null) {
                return response.activeViolations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActiveViolationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActiveViolationsResponseFetcher
    implements AsyncPageFetcher<ListActiveViolationsResponse> {
        private ListActiveViolationsResponseFetcher() {
        }

        public boolean hasNextPage(ListActiveViolationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActiveViolationsResponse> nextPage(ListActiveViolationsResponse previousPage) {
            if (previousPage == null) {
                return ListActiveViolationsPublisher.this.client.listActiveViolations(ListActiveViolationsPublisher.this.firstRequest);
            }
            return ListActiveViolationsPublisher.this.client.listActiveViolations((ListActiveViolationsRequest)((Object)ListActiveViolationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

