/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListDimensionsRequest;
import software.amazon.awssdk.services.iot.model.ListDimensionsResponse;

public class ListDimensionsIterable
implements SdkIterable<ListDimensionsResponse> {
    private final IotClient client;
    private final ListDimensionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDimensionsIterable(IotClient client, ListDimensionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDimensionsResponseFetcher();
    }

    public Iterator<ListDimensionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> dimensionNames() {
        Function<ListDimensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dimensionNames() != null) {
                return response.dimensionNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDimensionsResponseFetcher
    implements SyncPageFetcher<ListDimensionsResponse> {
        private ListDimensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDimensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDimensionsResponse nextPage(ListDimensionsResponse previousPage) {
            if (previousPage == null) {
                return ListDimensionsIterable.this.client.listDimensions(ListDimensionsIterable.this.firstRequest);
            }
            return ListDimensionsIterable.this.client.listDimensions((ListDimensionsRequest)((Object)ListDimensionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

