/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary;

public class ListTopicRuleDestinationsPublisher
implements SdkPublisher<ListTopicRuleDestinationsResponse> {
    private final IotAsyncClient client;
    private final ListTopicRuleDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTopicRuleDestinationsPublisher(IotAsyncClient client, ListTopicRuleDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTopicRuleDestinationsPublisher(IotAsyncClient client, ListTopicRuleDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTopicRuleDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTopicRuleDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TopicRuleDestinationSummary> destinationSummaries() {
        Function<ListTopicRuleDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinationSummaries() != null) {
                return response.destinationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTopicRuleDestinationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTopicRuleDestinationsResponseFetcher
    implements AsyncPageFetcher<ListTopicRuleDestinationsResponse> {
        private ListTopicRuleDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicRuleDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTopicRuleDestinationsResponse> nextPage(ListTopicRuleDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicRuleDestinationsPublisher.this.client.listTopicRuleDestinations(ListTopicRuleDestinationsPublisher.this.firstRequest);
            }
            return ListTopicRuleDestinationsPublisher.this.client.listTopicRuleDestinations((ListTopicRuleDestinationsRequest)((Object)ListTopicRuleDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

