/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataClient;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse;

public class ListItemsIterable
implements SdkIterable<ListItemsResponse> {
    private final MediaStoreDataClient client;
    private final ListItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListItemsIterable(MediaStoreDataClient client, ListItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListItemsResponseFetcher();
    }

    public Iterator<ListItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListItemsResponseFetcher
    implements SyncPageFetcher<ListItemsResponse> {
        private ListItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListItemsResponse nextPage(ListItemsResponse previousPage) {
            if (previousPage == null) {
                return ListItemsIterable.this.client.listItems(ListItemsIterable.this.firstRequest);
            }
            return ListItemsIterable.this.client.listItems((ListItemsRequest)((Object)ListItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

