/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.schemas.model.DiscovererState;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDiscovererResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, UpdateDiscovererResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::description)).setter(UpdateDiscovererResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISCOVERER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscovererArn").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::discovererArn)).setter(UpdateDiscovererResponse.setter(Builder::discovererArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererArn").build()}).build();
    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscovererId").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::discovererId)).setter(UpdateDiscovererResponse.setter(Builder::discovererId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::sourceArn)).setter(UpdateDiscovererResponse.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::stateAsString)).setter(UpdateDiscovererResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Boolean> CROSS_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrossAccount").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::crossAccount)).setter(UpdateDiscovererResponse.setter(Builder::crossAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccount").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateDiscovererResponse.getter(UpdateDiscovererResponse::tags)).setter(UpdateDiscovererResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISCOVERER_ARN_FIELD, DISCOVERER_ID_FIELD, SOURCE_ARN_FIELD, STATE_FIELD, CROSS_ACCOUNT_FIELD, TAGS_FIELD));
    private final String description;
    private final String discovererArn;
    private final String discovererId;
    private final String sourceArn;
    private final String state;
    private final Boolean crossAccount;
    private final Map<String, String> tags;

    private UpdateDiscovererResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.discovererArn = builder.discovererArn;
        this.discovererId = builder.discovererId;
        this.sourceArn = builder.sourceArn;
        this.state = builder.state;
        this.crossAccount = builder.crossAccount;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String discovererArn() {
        return this.discovererArn;
    }

    public final String discovererId() {
        return this.discovererId;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final DiscovererState state() {
        return DiscovererState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Boolean crossAccount() {
        return this.crossAccount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.discovererArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDiscovererResponse)) {
            return false;
        }
        UpdateDiscovererResponse other = (UpdateDiscovererResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.discovererArn(), other.discovererArn()) && Objects.equals(this.discovererId(), other.discovererId()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.crossAccount(), other.crossAccount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDiscovererResponse").add("Description", (Object)this.description()).add("DiscovererArn", (Object)this.discovererArn()).add("DiscovererId", (Object)this.discovererId()).add("SourceArn", (Object)this.sourceArn()).add("State", (Object)this.stateAsString()).add("CrossAccount", (Object)this.crossAccount()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiscovererArn": {
                return Optional.ofNullable(clazz.cast(this.discovererArn()));
            }
            case "DiscovererId": {
                return Optional.ofNullable(clazz.cast(this.discovererId()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CrossAccount": {
                return Optional.ofNullable(clazz.cast(this.crossAccount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDiscovererResponse, T> g) {
        return obj -> g.apply((UpdateDiscovererResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String description;
        private String discovererArn;
        private String discovererId;
        private String sourceArn;
        private String state;
        private Boolean crossAccount;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDiscovererResponse model) {
            super(model);
            this.description(model.description);
            this.discovererArn(model.discovererArn);
            this.discovererId(model.discovererId);
            this.sourceArn(model.sourceArn);
            this.state(model.state);
            this.crossAccount(model.crossAccount);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiscovererArn() {
            return this.discovererArn;
        }

        public final void setDiscovererArn(String discovererArn) {
            this.discovererArn = discovererArn;
        }

        @Override
        @Transient
        public final Builder discovererArn(String discovererArn) {
            this.discovererArn = discovererArn;
            return this;
        }

        public final String getDiscovererId() {
            return this.discovererId;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        @Override
        @Transient
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getCrossAccount() {
            return this.crossAccount;
        }

        public final void setCrossAccount(Boolean crossAccount) {
            this.crossAccount = crossAccount;
        }

        @Override
        @Transient
        public final Builder crossAccount(Boolean crossAccount) {
            this.crossAccount = crossAccount;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateDiscovererResponse build() {
            return new UpdateDiscovererResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDiscovererResponse> {
        public Builder description(String var1);

        public Builder discovererArn(String var1);

        public Builder discovererId(String var1);

        public Builder sourceArn(String var1);

        public Builder state(String var1);

        public Builder state(DiscovererState var1);

        public Builder crossAccount(Boolean var1);

        public Builder tags(Map<String, String> var1);
    }
}

