/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasAsyncClient;
import software.amazon.awssdk.services.schemas.model.SearchSchemaSummary;
import software.amazon.awssdk.services.schemas.model.SearchSchemasRequest;
import software.amazon.awssdk.services.schemas.model.SearchSchemasResponse;

public class SearchSchemasPublisher
implements SdkPublisher<SearchSchemasResponse> {
    private final SchemasAsyncClient client;
    private final SearchSchemasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSchemasPublisher(SchemasAsyncClient client, SearchSchemasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSchemasPublisher(SchemasAsyncClient client, SearchSchemasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSchemasResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSchemasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchSchemaSummary> schemas() {
        Function<SearchSchemasResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemas() != null) {
                return response.schemas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchSchemasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchSchemasResponseFetcher
    implements AsyncPageFetcher<SearchSchemasResponse> {
        private SearchSchemasResponseFetcher() {
        }

        public boolean hasNextPage(SearchSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSchemasResponse> nextPage(SearchSchemasResponse previousPage) {
            if (previousPage == null) {
                return SearchSchemasPublisher.this.client.searchSchemas(SearchSchemasPublisher.this.firstRequest);
            }
            return SearchSchemasPublisher.this.client.searchSchemas((SearchSchemasRequest)((Object)SearchSchemasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

