/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.PropertyKey;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPropertiesCopier;
import software.amazon.awssdk.services.servicecatalog.model.RecordStatus;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisionedProductPropertiesResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, UpdateProvisionedProductPropertiesResponse> {
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductId").getter(UpdateProvisionedProductPropertiesResponse.getter(UpdateProvisionedProductPropertiesResponse::provisionedProductId)).setter(UpdateProvisionedProductPropertiesResponse.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<Map<String, String>> PROVISIONED_PRODUCT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ProvisionedProductProperties").getter(UpdateProvisionedProductPropertiesResponse.getter(UpdateProvisionedProductPropertiesResponse::provisionedProductPropertiesAsStrings)).setter(UpdateProvisionedProductPropertiesResponse.setter(Builder::provisionedProductPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(UpdateProvisionedProductPropertiesResponse.getter(UpdateProvisionedProductPropertiesResponse::recordId)).setter(UpdateProvisionedProductPropertiesResponse.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateProvisionedProductPropertiesResponse.getter(UpdateProvisionedProductPropertiesResponse::statusAsString)).setter(UpdateProvisionedProductPropertiesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_PROPERTIES_FIELD, RECORD_ID_FIELD, STATUS_FIELD));
    private final String provisionedProductId;
    private final Map<String, String> provisionedProductProperties;
    private final String recordId;
    private final String status;

    private UpdateProvisionedProductPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductProperties = builder.provisionedProductProperties;
        this.recordId = builder.recordId;
        this.status = builder.status;
    }

    public final String provisionedProductId() {
        return this.provisionedProductId;
    }

    public final Map<PropertyKey, String> provisionedProductProperties() {
        return ProvisionedProductPropertiesCopier.copyStringToEnum(this.provisionedProductProperties);
    }

    public final boolean hasProvisionedProductProperties() {
        return this.provisionedProductProperties != null && !(this.provisionedProductProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> provisionedProductPropertiesAsStrings() {
        return this.provisionedProductProperties;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final RecordStatus status() {
        return RecordStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedProductProperties() ? this.provisionedProductPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductPropertiesResponse)) {
            return false;
        }
        UpdateProvisionedProductPropertiesResponse other = (UpdateProvisionedProductPropertiesResponse)((Object)obj);
        return Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && this.hasProvisionedProductProperties() == other.hasProvisionedProductProperties() && Objects.equals(this.provisionedProductPropertiesAsStrings(), other.provisionedProductPropertiesAsStrings()) && Objects.equals(this.recordId(), other.recordId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProvisionedProductPropertiesResponse").add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ProvisionedProductProperties", this.hasProvisionedProductProperties() ? this.provisionedProductPropertiesAsStrings() : null).add("RecordId", (Object)this.recordId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ProvisionedProductProperties": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductPropertiesAsStrings()));
            }
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedProductPropertiesResponse, T> g) {
        return obj -> g.apply((UpdateProvisionedProductPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String provisionedProductId;
        private Map<String, String> provisionedProductProperties = DefaultSdkAutoConstructMap.getInstance();
        private String recordId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductPropertiesResponse model) {
            super(model);
            this.provisionedProductId(model.provisionedProductId);
            this.provisionedProductPropertiesWithStrings(model.provisionedProductProperties);
            this.recordId(model.recordId);
            this.status(model.status);
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        @Override
        @Transient
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final Map<String, String> getProvisionedProductProperties() {
            if (this.provisionedProductProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.provisionedProductProperties;
        }

        public final void setProvisionedProductProperties(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
        }

        @Override
        @Transient
        public final Builder provisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
            return this;
        }

        @Override
        @Transient
        public final Builder provisionedProductProperties(Map<PropertyKey, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copyEnumToString(provisionedProductProperties);
            return this;
        }

        public final String getRecordId() {
            return this.recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        @Transient
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateProvisionedProductPropertiesResponse build() {
            return new UpdateProvisionedProductPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProvisionedProductPropertiesResponse> {
        public Builder provisionedProductId(String var1);

        public Builder provisionedProductPropertiesWithStrings(Map<String, String> var1);

        public Builder provisionedProductProperties(Map<PropertyKey, String> var1);

        public Builder recordId(String var1);

        public Builder status(String var1);

        public Builder status(RecordStatus var1);
    }
}

