/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.AWSDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.avro.AWSAvroDeserializer;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class AWSDeserializerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSDeserializerFactory.class);
    private final ConcurrentHashMap<DataFormat, AWSDataFormatDeserializer> deserializerMap = new ConcurrentHashMap();

    public AWSDataFormatDeserializer getInstance(@NonNull DataFormat dataFormat, @NonNull GlueSchemaRegistryConfiguration configs) {
        if (dataFormat == null) {
            throw new IllegalArgumentException("dataFormat is marked @NonNull but is null");
        }
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked @NonNull but is null");
        }
        switch (dataFormat) {
            case AVRO: {
                this.deserializerMap.computeIfAbsent(dataFormat, key -> {
                    AWSAvroDeserializer awsAvroDeserializer = AWSAvroDeserializer.builder().configs(configs).build();
                    return awsAvroDeserializer;
                });
                log.debug("Returning Avro de-serializer instance from AWSDeserializerFactory");
                return this.deserializerMap.get(dataFormat);
            }
        }
        String message = String.format("Data Format is not supported %s", dataFormat);
        throw new UnsupportedOperationException(message);
    }
}

