/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializer;
import com.google.common.annotations.VisibleForTesting;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class GlueSchemaRegistryDeserializerImpl
implements GlueSchemaRegistryDeserializer {
    private AWSDeserializer awsDeserializer;

    public GlueSchemaRegistryDeserializerImpl(AwsCredentialsProvider awsCredentialsProvider, GlueSchemaRegistryConfiguration configuration) {
        this.awsDeserializer = new AWSDeserializer(configuration, awsCredentialsProvider);
    }

    @VisibleForTesting
    protected GlueSchemaRegistryDeserializerImpl(AWSDeserializer awsDeserializer) {
        this.awsDeserializer = awsDeserializer;
    }

    @Override
    public byte[] getData(byte[] encodedData) {
        return this.awsDeserializer.getActualData(encodedData);
    }

    @Override
    public Schema getSchema(byte[] data) {
        return this.awsDeserializer.getSchema(data);
    }

    @Override
    public boolean canDeserialize(byte[] data) {
        return this.awsDeserializer.canDeserialize(data);
    }
}

