/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSCompressionFactory;
import com.amazonaws.services.schemaregistry.common.AWSDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerDataParser;
import com.amazonaws.services.schemaregistry.exception.AWSIncompatibleDataException;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSAvroDeserializer
implements AWSDataFormatDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSAvroDeserializer.class);
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;
    private AvroRecordType avroRecordType;
    private AWSCompressionFactory compressionFactory;

    public AWSAvroDeserializer(GlueSchemaRegistryConfiguration configs) {
        this.schemaRegistrySerDeConfigs = configs;
        this.avroRecordType = configs.getAvroRecordType();
        this.compressionFactory = new AWSCompressionFactory();
    }

    public Object deserialize(@NonNull byte[] data, @NonNull String schema) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is marked @NonNull but is null");
        }
        return this.deserialize(UUID.randomUUID(), ByteBuffer.wrap(data), schema);
    }

    public Object deserialize(@NonNull ByteBuffer buffer, @NonNull String schema) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is marked @NonNull but is null");
        }
        return this.deserialize(UUID.randomUUID(), buffer, schema);
    }

    public Object deserialize(@NonNull UUID schemaVersionId, @NonNull ByteBuffer buffer, @NonNull String schema) {
        if (schemaVersionId == null) {
            throw new IllegalArgumentException("schemaVersionId is marked @NonNull but is null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is marked @NonNull but is null");
        }
        try {
            StringBuilder errorMessageBuilder = new StringBuilder();
            if (!AWSDeserializerDataParser.getInstance().isDataCompatible(buffer, errorMessageBuilder)) {
                throw new AWSIncompatibleDataException(errorMessageBuilder.toString());
            }
            buffer.getLong();
            buffer.getLong();
            byte[] data = this.getDeserializedData(buffer);
            log.debug("Length of actual message: {}, schema version id = {}", (Object)data.length, (Object)schemaVersionId);
            Schema schemaDefinition = this.getSchemaDefinition(schema);
            DatumReader<Object> datumReader = this.createDatumReader(schemaDefinition, schemaVersionId);
            BinaryDecoder binaryDecoder = this.getBinaryDecoder(data, 0, data.length);
            Object result = datumReader.read(null, (Decoder)binaryDecoder);
            log.debug("Finished de-serializing Avro message, schema version id: {}", (Object)schemaVersionId);
            return result;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            String message = String.format("Exception occurred while de-serializing Avro message, schema version id: %s", schemaVersionId);
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    public byte[] getDeserializedData(ByteBuffer buffer) throws IOException {
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        if (AWSDeserializerDataParser.getInstance().isCompressionEnabled(buffer)) {
            data = this.decompressData(buffer, this.getHeaderLength(), this.dataLength(buffer));
        }
        return data;
    }

    private BinaryDecoder getBinaryDecoder(byte[] data, int start, int end) {
        return DecoderFactory.get().binaryDecoder(data, start, end, null);
    }

    private int dataLength(ByteBuffer data) {
        return data.limit() - this.getHeaderLength();
    }

    private int getHeaderLength() {
        return 18;
    }

    private byte[] decompressData(ByteBuffer buffer, int start, int end) throws IOException {
        return this.compressionFactory.getCompressionHandler(AWSDeserializerDataParser.getInstance().getCompressionByte(buffer).byteValue()).decompress(buffer.array(), start, end);
    }

    private Schema getSchemaDefinition(String schema) {
        Schema schemaDefinition;
        try {
            schemaDefinition = new Schema.Parser().parse(schema);
        }
        catch (SchemaParseException e) {
            String message = "Error occurred while parsing schema, see inner exception for details. ";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
        return schemaDefinition;
    }

    public DatumReader<Object> createDatumReader(Schema writerSchema, UUID schemaVersionId) throws InstantiationException, IllegalAccessException {
        switch (this.avroRecordType) {
            case SPECIFIC_RECORD: {
                Class readerClass = SpecificData.get().getClass(writerSchema);
                Schema readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
                log.debug("Using SpecificDatumReader for de-serializing Avro message, schema version id: {}, schema: {})", (Object)schemaVersionId, (Object)readerSchema.toString());
                return new SpecificDatumReader(writerSchema, readerSchema);
            }
            case GENERIC_RECORD: {
                log.debug("Using GenericDatumReader for de-serializing Avro message, schema version id: {}, schema: {})", (Object)schemaVersionId, (Object)writerSchema.toString());
                return new GenericDatumReader(writerSchema);
            }
        }
        String message = String.format("Data Format in configuration is not supported, Data Format: %s ", this.avroRecordType.getName());
        throw new UnsupportedOperationException(message);
    }

    @Generated
    public static AWSAvroDeserializerBuilder builder() {
        return new AWSAvroDeserializerBuilder();
    }

    @Generated
    public GlueSchemaRegistryConfiguration getSchemaRegistrySerDeConfigs() {
        return this.schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setSchemaRegistrySerDeConfigs(GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs) {
        this.schemaRegistrySerDeConfigs = schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setAvroRecordType(AvroRecordType avroRecordType) {
        this.avroRecordType = avroRecordType;
    }

    @Generated
    public void setCompressionFactory(AWSCompressionFactory compressionFactory) {
        this.compressionFactory = compressionFactory;
    }

    @Generated
    public static class AWSAvroDeserializerBuilder {
        @Generated
        private GlueSchemaRegistryConfiguration configs;

        @Generated
        AWSAvroDeserializerBuilder() {
        }

        @Generated
        public AWSAvroDeserializerBuilder configs(GlueSchemaRegistryConfiguration configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public AWSAvroDeserializer build() {
            return new AWSAvroDeserializer(this.configs);
        }

        @Generated
        public String toString() {
            return "AWSAvroDeserializer.AWSAvroDeserializerBuilder(configs=" + this.configs + ")";
        }
    }
}

