/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSSchemaNamingStrategy;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.GlueSchemaRegistryUtils;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class AWSKafkaAvroSerializer
implements Serializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSKafkaAvroSerializer.class);
    private static final DataFormat DATA_FORMAT = DataFormat.AVRO;
    private GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade;
    private final AwsCredentialsProvider credentialProvider;
    private final UUID schemaVersionId;
    private String schemaName;
    private AWSSchemaNamingStrategy schemaNamingStrategy;
    private boolean isKey;
    private String userAgentApp;

    public AWSKafkaAvroSerializer() {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), null, null);
    }

    public AWSKafkaAvroSerializer(Map<String, ?> configs) {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), null, configs);
    }

    public AWSKafkaAvroSerializer(AwsCredentialsProvider credentialProvider, Map<String, ?> configs) {
        this(credentialProvider, null, configs);
    }

    public AWSKafkaAvroSerializer(@NonNull Map<String, ?> configs, UUID schemaVersionId) {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), schemaVersionId, configs);
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked non-null but is null");
        }
    }

    public AWSKafkaAvroSerializer(AwsCredentialsProvider credentialProvider, UUID schemaVersionId, Map<String, ?> configs) {
        this.credentialProvider = credentialProvider == null ? DefaultCredentialsProvider.builder().build() : credentialProvider;
        this.schemaVersionId = schemaVersionId;
        if (configs != null) {
            this.configure(configs, false);
        }
    }

    public void configure(@NonNull Map<String, ?> configs, boolean isKey) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked non-null but is null");
        }
        this.schemaName = GlueSchemaRegistryUtils.getInstance().getSchemaName(configs);
        this.isKey = isKey;
        if (this.schemaName == null) {
            this.schemaNamingStrategy = GlueSchemaRegistryUtils.getInstance().configureSchemaNamingStrategy(configs);
        }
        GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        if (this.userAgentApp == null) {
            this.userAgentApp = "kafka";
        }
        glueSchemaRegistryConfiguration.setUserAgentApp(this.userAgentApp);
        this.glueSchemaRegistrySerializationFacade = GlueSchemaRegistrySerializationFacade.builder().glueSchemaRegistryConfiguration(glueSchemaRegistryConfiguration).credentialProvider(this.credentialProvider).build();
    }

    public byte[] serialize(String topic, Object data) {
        byte[] result = null;
        if (null == data) {
            return null;
        }
        UUID schemaVersionIdFromRegistry = null;
        if (this.schemaVersionId == null) {
            log.debug("Schema Version Id is null. Trying to register the schema.");
            schemaVersionIdFromRegistry = this.glueSchemaRegistrySerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(data, topic, this.isKey));
        } else {
            schemaVersionIdFromRegistry = this.schemaVersionId;
        }
        if (schemaVersionIdFromRegistry != null) {
            log.debug("Schema Version Id received from the from schema registry: {}", (Object)schemaVersionIdFromRegistry);
            result = this.glueSchemaRegistrySerializationFacade.serialize(DATA_FORMAT, data, schemaVersionIdFromRegistry);
        }
        return result;
    }

    public void close() {
    }

    private String getSchemaName(String topic, Object data, Boolean isKey) {
        if (this.schemaName == null) {
            return this.schemaNamingStrategy.getSchemaName(topic, data, isKey.booleanValue());
        }
        return this.schemaName;
    }

    private AWSSerializerInput prepareInput(@NonNull Object data, String topic, Boolean isKey) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        return AWSSerializerInput.builder().schemaDefinition(AVROUtils.getInstance().getSchemaDefinition(data)).schemaName(this.getSchemaName(topic, data, isKey)).transportName(topic).dataFormat(DATA_FORMAT.name()).build();
    }

    @Generated
    public GlueSchemaRegistrySerializationFacade getGlueSchemaRegistrySerializationFacade() {
        return this.glueSchemaRegistrySerializationFacade;
    }

    @Generated
    public AwsCredentialsProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    @Generated
    public UUID getSchemaVersionId() {
        return this.schemaVersionId;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public AWSSchemaNamingStrategy getSchemaNamingStrategy() {
        return this.schemaNamingStrategy;
    }

    @Generated
    public boolean isKey() {
        return this.isKey;
    }

    @Generated
    public String getUserAgentApp() {
        return this.userAgentApp;
    }

    @Generated
    public void setGlueSchemaRegistrySerializationFacade(GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade) {
        this.glueSchemaRegistrySerializationFacade = glueSchemaRegistrySerializationFacade;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setSchemaNamingStrategy(AWSSchemaNamingStrategy schemaNamingStrategy) {
        this.schemaNamingStrategy = schemaNamingStrategy;
    }

    @Generated
    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AWSKafkaAvroSerializer)) {
            return false;
        }
        AWSKafkaAvroSerializer other = (AWSKafkaAvroSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKey() != other.isKey()) {
            return false;
        }
        GlueSchemaRegistrySerializationFacade this$glueSchemaRegistrySerializationFacade = this.getGlueSchemaRegistrySerializationFacade();
        GlueSchemaRegistrySerializationFacade other$glueSchemaRegistrySerializationFacade = other.getGlueSchemaRegistrySerializationFacade();
        if (this$glueSchemaRegistrySerializationFacade == null ? other$glueSchemaRegistrySerializationFacade != null : !this$glueSchemaRegistrySerializationFacade.equals(other$glueSchemaRegistrySerializationFacade)) {
            return false;
        }
        AwsCredentialsProvider this$credentialProvider = this.getCredentialProvider();
        AwsCredentialsProvider other$credentialProvider = other.getCredentialProvider();
        if (this$credentialProvider == null ? other$credentialProvider != null : !this$credentialProvider.equals(other$credentialProvider)) {
            return false;
        }
        UUID this$schemaVersionId = this.getSchemaVersionId();
        UUID other$schemaVersionId = other.getSchemaVersionId();
        if (this$schemaVersionId == null ? other$schemaVersionId != null : !((Object)this$schemaVersionId).equals(other$schemaVersionId)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        AWSSchemaNamingStrategy this$schemaNamingStrategy = this.getSchemaNamingStrategy();
        AWSSchemaNamingStrategy other$schemaNamingStrategy = other.getSchemaNamingStrategy();
        if (this$schemaNamingStrategy == null ? other$schemaNamingStrategy != null : !this$schemaNamingStrategy.equals(other$schemaNamingStrategy)) {
            return false;
        }
        String this$userAgentApp = this.getUserAgentApp();
        String other$userAgentApp = other.getUserAgentApp();
        return !(this$userAgentApp == null ? other$userAgentApp != null : !this$userAgentApp.equals(other$userAgentApp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AWSKafkaAvroSerializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKey() ? 79 : 97);
        GlueSchemaRegistrySerializationFacade $glueSchemaRegistrySerializationFacade = this.getGlueSchemaRegistrySerializationFacade();
        result = result * 59 + ($glueSchemaRegistrySerializationFacade == null ? 43 : $glueSchemaRegistrySerializationFacade.hashCode());
        AwsCredentialsProvider $credentialProvider = this.getCredentialProvider();
        result = result * 59 + ($credentialProvider == null ? 43 : $credentialProvider.hashCode());
        UUID $schemaVersionId = this.getSchemaVersionId();
        result = result * 59 + ($schemaVersionId == null ? 43 : ((Object)$schemaVersionId).hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        AWSSchemaNamingStrategy $schemaNamingStrategy = this.getSchemaNamingStrategy();
        result = result * 59 + ($schemaNamingStrategy == null ? 43 : $schemaNamingStrategy.hashCode());
        String $userAgentApp = this.getUserAgentApp();
        result = result * 59 + ($userAgentApp == null ? 43 : $userAgentApp.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AWSKafkaAvroSerializer(glueSchemaRegistrySerializationFacade=" + this.getGlueSchemaRegistrySerializationFacade() + ", credentialProvider=" + this.getCredentialProvider() + ", schemaVersionId=" + this.getSchemaVersionId() + ", schemaName=" + this.getSchemaName() + ", schemaNamingStrategy=" + this.getSchemaNamingStrategy() + ", isKey=" + this.isKey() + ", userAgentApp=" + this.getUserAgentApp() + ")";
    }

    @Generated
    public void setUserAgentApp(String userAgentApp) {
        this.userAgentApp = userAgentApp;
    }
}

