/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.json;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatSerializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.json.JsonDataWithSchema;
import com.amazonaws.services.schemaregistry.serializers.json.JsonValidator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.kjetland.jackson.jsonSchema.JsonSchemaGenerator;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements GlueSchemaRegistryDataFormatSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    private static final JsonValidator JSON_VALIDATOR = new JsonValidator();
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final ObjectMapper objectMapper;
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;

    public JsonSerializer(GlueSchemaRegistryConfiguration configs) {
        this.schemaRegistrySerDeConfigs = configs;
        JsonNodeFactory jsonNodeFactory = JsonNodeFactory.withExactBigDecimals((boolean)true);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setNodeFactory(jsonNodeFactory);
        if (configs != null) {
            if (!CollectionUtils.isEmpty((Collection)configs.getJacksonSerializationFeatures())) {
                configs.getJacksonSerializationFeatures().forEach(arg_0 -> ((ObjectMapper)this.objectMapper).enable(arg_0));
            }
            if (!CollectionUtils.isEmpty((Collection)configs.getJacksonDeserializationFeatures())) {
                configs.getJacksonDeserializationFeatures().forEach(arg_0 -> ((ObjectMapper)this.objectMapper).enable(arg_0));
            }
        }
        this.jsonSchemaGenerator = new JsonSchemaGenerator(this.objectMapper);
    }

    public byte[] serialize(Object data) {
        JsonNode dataNode = this.getDataNode(data);
        JsonNode schemaNode = this.getSchemaNode(data);
        JSON_VALIDATOR.validateDataWithSchema(schemaNode, dataNode);
        byte[] bytes = this.writeBytes(dataNode);
        return bytes;
    }

    private byte[] writeBytes(JsonNode dataNode) {
        byte[] bytes;
        try {
            bytes = this.objectMapper.writeValueAsBytes((Object)dataNode);
        }
        catch (Exception e) {
            throw new AWSSchemaRegistryException(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    private boolean isWrapper(Object object) {
        return object instanceof JsonDataWithSchema;
    }

    public String getSchemaDefinition(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is marked non-null but is null");
        }
        JsonNode schema = this.getSchemaNode(object);
        return schema.toString();
    }

    private JsonNode getSchemaNode(@NonNull Object object) {
        JsonNode schemaNode;
        if (object == null) {
            throw new IllegalArgumentException("object is marked non-null but is null");
        }
        if (this.isWrapper(object)) {
            schemaNode = this.getSchemaNodeFromWrapperObject((JsonDataWithSchema)object);
        } else {
            try {
                schemaNode = this.jsonSchemaGenerator.generateJsonSchema(object.getClass());
            }
            catch (Exception e) {
                throw new AWSSchemaRegistryException("Could not generate schema from the type provided " + object.getClass(), (Throwable)e);
            }
        }
        return schemaNode;
    }

    private JsonNode getDataNode(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is marked non-null but is null");
        }
        if (this.isWrapper(object)) {
            return this.getDataNodeFromWrapperObject((JsonDataWithSchema)object);
        }
        return this.getDataNodeFromSpecificObject(object);
    }

    private JsonNode getSchemaNodeFromWrapperObject(JsonDataWithSchema object) {
        String schema = object.getSchema();
        return this.convertToJsonNode(schema);
    }

    private JsonNode getDataNodeFromWrapperObject(JsonDataWithSchema object) {
        String payload = object.getPayload();
        return this.convertToJsonNode(payload);
    }

    private JsonNode getDataNodeFromSpecificObject(Object object) {
        try {
            return this.objectMapper.valueToTree(object);
        }
        catch (Exception e) {
            throw new AWSSchemaRegistryException("Not a valid Specific Json Record.", (Throwable)e);
        }
    }

    private JsonNode convertToJsonNode(String jsonString) {
        try {
            return this.objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new AWSSchemaRegistryException("Malformed JSON", (Throwable)e);
        }
    }

    public void validate(String schemaDefinition, byte[] data) {
        String payload = new String(data, StandardCharsets.UTF_8);
        JsonDataWithSchema jsonDataWithSchema = new JsonDataWithSchema(schemaDefinition, payload);
        this.validate(jsonDataWithSchema);
    }

    public void validate(Object jsonDataWithSchema) {
        JsonNode schemaNode = this.getSchemaNode(jsonDataWithSchema);
        JsonNode dataNode = this.getDataNode(jsonDataWithSchema);
        JSON_VALIDATOR.validateDataWithSchema(schemaNode, dataNode);
    }

    @Generated
    public static JsonSerializerBuilder builder() {
        return new JsonSerializerBuilder();
    }

    @Generated
    public GlueSchemaRegistryConfiguration getSchemaRegistrySerDeConfigs() {
        return this.schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setSchemaRegistrySerDeConfigs(GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs) {
        this.schemaRegistrySerDeConfigs = schemaRegistrySerDeConfigs;
    }

    @Generated
    public static class JsonSerializerBuilder {
        @Generated
        private GlueSchemaRegistryConfiguration configs;

        @Generated
        JsonSerializerBuilder() {
        }

        @Generated
        public JsonSerializerBuilder configs(GlueSchemaRegistryConfiguration configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public JsonSerializer build() {
            return new JsonSerializer(this.configs);
        }

        @Generated
        public String toString() {
            return "JsonSerializer.JsonSerializerBuilder(configs=" + this.configs + ")";
        }
    }
}

