/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.config;

import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"tech.powerjob.server.persistence.local"}, entityManagerFactoryRef="localEntityManagerFactory", transactionManagerRef="localTransactionManager")
public class LocalJpaConfig {
    public static final String LOCAL_PACKAGES = "tech.powerjob.server.persistence.local";

    private static Map<String, Object> genDatasourceProperties() {
        JpaProperties jpaProperties = new JpaProperties();
        jpaProperties.setOpenInView(Boolean.valueOf(false));
        jpaProperties.setShowSql(false);
        HibernateProperties hibernateProperties = new HibernateProperties();
        hibernateProperties.setDdlAuto("create");
        return hibernateProperties.determineHibernateProperties(jpaProperties.getProperties(), new HibernateSettings());
    }

    @Bean(name={"localEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean initLocalEntityManagerFactory(@Qualifier(value="omsLocalDatasource") DataSource omsLocalDatasource, EntityManagerFactoryBuilder builder) {
        return builder.dataSource(omsLocalDatasource).properties(LocalJpaConfig.genDatasourceProperties()).packages(new String[]{LOCAL_PACKAGES}).persistenceUnit("localPersistenceUnit").build();
    }

    @Bean(name={"localTransactionManager"})
    public PlatformTransactionManager initLocalTransactionManager(@Qualifier(value="localEntityManagerFactory") LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean) {
        return new JpaTransactionManager(Objects.requireNonNull(localContainerEntityManagerFactoryBean.getObject()));
    }

    @Bean(name={"localTransactionTemplate"})
    public TransactionTemplate initTransactionTemplate(@Qualifier(value="localTransactionManager") PlatformTransactionManager ptm) {
        TransactionTemplate tt = new TransactionTemplate(ptm);
        tt.setIsolationLevel(-1);
        return tt;
    }
}

