/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import tech.powerjob.server.common.utils.OmsFileUtils;

@Configuration
public class MultiDatasourceConfig {
    private static final String H2_DRIVER_CLASS_NAME = "org.h2.Driver";
    private static final String H2_JDBC_URL_PATTERN = "jdbc:h2:file:%spowerjob_server_db";
    private static final int H2_MIN_SIZE = 4;
    private static final int H2_MAX_ACTIVE_SIZE = 10;

    @Primary
    @Bean(value={"omsRemoteDatasource"})
    @ConfigurationProperties(prefix="spring.datasource.core")
    public DataSource initOmsCoreDatasource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(value={"omsLocalDatasource"})
    public DataSource initOmsLocalDatasource() {
        String h2Path = OmsFileUtils.genH2WorkPath();
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(H2_DRIVER_CLASS_NAME);
        config.setJdbcUrl(String.format(H2_JDBC_URL_PATTERN, h2Path));
        config.setAutoCommit(true);
        config.setMinimumIdle(4);
        config.setMaximumPoolSize(10);
        try {
            FileUtils.forceDeleteOnExit((File)new File(h2Path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new HikariDataSource(config);
    }
}

