/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import sun.misc.Unsafe;

public class ReflectUtil {
    private static Logger log = LoggerFactory.getLogger(ReflectUtil.class);

    public static Class<?> getGenericInterfaces(Class<?> clazz, int index) {
        Type[] type = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        return (Class)type[index];
    }

    public static Method getReadMethod(Class<?> clazz, String fieldName) {
        try {
            Assert.notNull((Object)fieldName);
            char cha = Character.toUpperCase(fieldName.charAt(0));
            String methodName = (Object)((Object)MethodPrefix.get) + String.valueOf(cha) + fieldName.substring(1);
            return ReflectUtil.findMethod(clazz, methodName, new Class[0]);
        }
        catch (Exception e) {
            log.info("getReadMethod ERROR: {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public static List<Method> getAllReadMethod(Class<?> clazz, String ... ignoreFieldNames) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        try {
            Field[] fields = ReflectUtil.findFields(clazz);
            HashSet set = null;
            if (ignoreFieldNames != null && ignoreFieldNames.length > 0) {
                set = new HashSet();
                Collections.addAll(set, ignoreFieldNames);
            }
            for (Field field : fields) {
                Method readMethod;
                if ("serialVersionUID".equals(field.getName()) || set != null && !set.contains(field.getName()) || (readMethod = ReflectUtil.getReadMethod(clazz, field.getName())) == null) continue;
                methodList.add(readMethod);
            }
        }
        catch (Exception e) {
            log.info("getAllReadMethod ERROR: {}", (Object)e.getLocalizedMessage());
        }
        return methodList;
    }

    public static Method getWriteMethod(Class<?> clazz, String fieldName) {
        try {
            Assert.notNull((Object)fieldName);
            Field f = ReflectUtil.findField(clazz, fieldName);
            char cha = Character.toUpperCase(fieldName.charAt(0));
            String methodName = (Object)((Object)MethodPrefix.set) + String.valueOf(cha) + fieldName.substring(1);
            return ReflectUtil.findMethod(clazz, methodName, f.getType());
        }
        catch (Exception e) {
            log.info("getWriteMethod ERROR: {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public static Method getWriteMethodByRead(Class<?> clazz, Method method) {
        try {
            Assert.notNull(clazz);
            Assert.notNull((Object)method);
            String methodName = method.getName();
            if (methodName.startsWith(MethodPrefix.get.toString())) {
                String fieldName = methodName.substring(3);
                char cha = Character.toLowerCase(fieldName.charAt(0));
                return ReflectUtil.getWriteMethod(clazz, String.valueOf(cha) + fieldName.substring(1));
            }
        }
        catch (Exception e) {
            log.info("getWriteMethod ERROR: {}", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    public static List<Method> getAllWriteMethod(Class<?> clazz, String ... ignoreFieldNames) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        try {
            Field[] fields = ReflectUtil.findFields(clazz);
            HashSet set = null;
            if (ignoreFieldNames != null && ignoreFieldNames.length > 0) {
                set = new HashSet();
                Collections.addAll(set, ignoreFieldNames);
            }
            for (Field field : fields) {
                Method readMethod;
                if ("serialVersionUID".equals(field.getName()) || set != null && !set.contains(field.getName()) || (readMethod = ReflectUtil.getWriteMethod(clazz, field.getName())) == null) continue;
                methodList.add(readMethod);
            }
        }
        catch (Exception e) {
            log.info("getAllWriteMethod ERROR: {}", (Object)e.getLocalizedMessage());
        }
        return methodList;
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            String msg = "Class method parameter cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class [" + clazz.getName() + "]", e);
        }
    }

    public static Field findField(Class<?> type, String fieldName) {
        Assert.notNull(type, (String)"type must not be null!");
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null!");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            try {
                foundField = targetClass.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (foundField != null) break;
        }
        return foundField;
    }

    public static Method findMethod(Class<?> type, String methodName, Class<?> ... classes) {
        Assert.notNull(type, (String)"type must not be null!");
        Assert.notNull((Object)methodName, (String)"fieldName must not be null!");
        Method foundMethod = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            try {
                foundMethod = targetClass.getDeclaredMethod(methodName, classes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (foundMethod != null) break;
        }
        return foundMethod;
    }

    public static Method[] findMethods(Class<?> type) {
        Assert.notNull(type, (String)"type must not be null!");
        Class<?> targetClass = type;
        ArrayList<Method> methodList = new ArrayList<Method>();
        while (targetClass != Object.class) {
            try {
                methodList.addAll(Arrays.asList(targetClass.getDeclaredMethods()));
                targetClass = targetClass.getSuperclass();
            }
            catch (Exception exception) {}
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Field[] findFields(Class<?> type) {
        Assert.notNull(type, (String)"type must not be null!");
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(targetClass.getDeclaredFields()));
        }
        List<Field> result = fieldList.stream().filter(field -> !field.getName().equals("serialVersionUID")).collect(Collectors.toList());
        return result.toArray(new Field[result.size()]);
    }

    public static <T> T getFieldValue(Object obj, String fieldName, Class<T> valType) {
        Field field = ReflectUtil.findField(obj.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (T)field.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Unsafe getUnsafe() {
        try {
            Field theUnsafeInstance = ReflectUtil.findField(Unsafe.class, "theUnsafe");
            theUnsafeInstance.setAccessible(true);
            return (Unsafe)theUnsafeInstance.get(Unsafe.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static enum MethodPrefix {
        get,
        set;

    }
}

