/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import java.io.File;
import ws.schild.jave.filters.Filter;
import ws.schild.jave.filters.helpers.Color;
import ws.schild.jave.utils.Utils;

public class DrawtextFilter
extends Filter {
    public DrawtextFilter(String text, String posX, String posY) {
        super("drawtext");
        this.addNamedArgument("text", Utils.escapeArgument(text));
        this.addNamedArgument("x", posX.toString());
        this.addNamedArgument("y", posY.toString());
    }

    public DrawtextFilter(String text, String posX, String posY, String fontName, Double fontSize, Color fontColor) throws IllegalArgumentException {
        this(text, posX, posY);
        this.addNamedArgument("font", fontName);
        this.addNamedArgument("fontsize", fontSize.toString());
        this.addNamedArgument("fontcolor", fontColor.toString());
    }

    public DrawtextFilter(String text, String posX, String posY, File fontFile, Double fontSize, Color fontColor) throws IllegalArgumentException {
        this(text, posX, posY);
        this.addNamedArgument("fontfile", fontFile.getAbsolutePath());
        this.addNamedArgument("fontsize", fontSize.toString());
        this.addNamedArgument("fontcolor", fontColor.toString());
    }

    public DrawtextFilter setShadow(Color shadowColor, Integer shadowX, Integer shadowY) {
        this.addNamedArgument("shadowcolor", shadowColor.toString());
        this.addNamedArgument("shadowx", shadowX.toString());
        this.addNamedArgument("shadowy", shadowY.toString());
        return this;
    }

    public DrawtextFilter setBox(Integer borderWidth, Color color) {
        this.addNamedArgument("box", "1");
        this.addNamedArgument("boxcolor", color.toString());
        this.addNamedArgument("boxborderw", borderWidth.toString());
        return this;
    }

    public DrawtextFilter setBorder(Integer borderWidth, Color color) {
        this.addNamedArgument("bordercolor", color.toString());
        this.addNamedArgument("borderw", borderWidth.toString());
        return this;
    }

    public DrawtextFilter setLineSpacing(Integer lineSpacing) {
        this.addNamedArgument("line_spacing", lineSpacing.toString());
        return this;
    }
}

