/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ws.schild.jave.filters.VideoFilter;

public class Filter
implements VideoFilter {
    private List<String> inputLinkLabels = new ArrayList<String>();
    private String name;
    private List<String> orderedArguments;
    private Map<String, String> namedArguments;
    private List<String> outputLinkLabels;

    public Filter(String name) {
        this.name = name;
        this.orderedArguments = new ArrayList<String>();
        this.namedArguments = new HashMap<String, String>();
        this.outputLinkLabels = new ArrayList<String>();
    }

    public Filter addInputLabel(String ... label) {
        this.inputLinkLabels.addAll(Arrays.asList(label));
        return this;
    }

    public Filter addOrderedArgument(String ... arg) {
        this.orderedArguments.addAll(Arrays.asList(arg));
        return this;
    }

    public Filter addNamedArgument(String name, String value) {
        this.namedArguments.put(name, value);
        return this;
    }

    public Filter addOutputLabel(String ... label) {
        this.outputLinkLabels.addAll(Arrays.asList(label));
        return this;
    }

    @Override
    public String getExpression() {
        return Filter.formatLinkLabels(this.inputLinkLabels) + this.name + this.formatArguments() + Filter.formatLinkLabels(this.outputLinkLabels);
    }

    private static String formatLinkLabels(List<String> labels) {
        return labels.stream().map(labelName -> "[" + labelName + "]").collect(Collectors.joining());
    }

    private String formatArguments() {
        return (this.orderedArguments.size() + this.namedArguments.size() > 0 ? "='" : "") + Stream.concat(this.orderedArguments.stream(), this.namedArguments.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue())).collect(Collectors.joining(":")) + (this.orderedArguments.size() + this.namedArguments.size() > 0 ? "'" : "");
    }
}

