/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.utils;

import android.app.Activity;
import android.app.Application;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import xyz.truenight.utils.SimpleActivityLifecycleCallbacks;
import xyz.truenight.utils.Utils;

public class BaseApplication
extends Application {
    private static BaseApplication msApplication = null;
    private WeakReference<Activity> mCurrentActivity;

    public static BaseApplication getInstance() {
        return msApplication;
    }

    public Activity topActivity() {
        return (Activity)Utils.unwrap(this.mCurrentActivity);
    }

    public void onCreate() {
        msApplication = this;
        this.mCurrentActivity = null;
        this.registerActivityLifecycleCallbacks(new SimpleActivityLifecycleCallbacks(){

            @Override
            public void onActivityResumed(Activity activity) {
                BaseApplication.this.mCurrentActivity = new WeakReference<Activity>(activity);
            }

            @Override
            public void onActivityDestroyed(Activity activity) {
                if (Utils.unwrap((Reference)BaseApplication.this.mCurrentActivity) == activity) {
                    BaseApplication.this.mCurrentActivity = null;
                }
            }
        });
        super.onCreate();
    }
}

