/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import java.util.HashMap;
import java.util.HashSet;

public class PermissionRequest {
    private static final HashMap<Integer, ResponseWrapper> map = new HashMap();

    public static void getPermission(@NonNull Activity context, String permissions, @NonNull Response response) {
        PermissionRequest.getPermission(context, new String[]{permissions}, response);
    }

    public static void getPermission(@NonNull Fragment context, String permissions, @NonNull Response response) {
        PermissionRequest.getPermission(context, new String[]{permissions}, response);
    }

    public static boolean hasAllPermission(@NonNull Context context, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAllPermission(@NonNull Fragment context, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context.getContext(), (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public static void getPermission(@NonNull Activity context, @NonNull String[] permissions, @NonNull Response response) {
        if (Build.VERSION.SDK_INT < 23) {
            response.permissionGranted();
        } else {
            HashSet<String> permissionSet = new HashSet<String>();
            for (String permission : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
                permissionSet.add(permission);
            }
            if (permissionSet.size() > 0) {
                int id2 = 42167;
                while (map.containsKey(id2)) {
                    id2 = (int)Math.round(Math.random() * 2.147483647E9);
                }
                map.put(id2, new ResponseWrapper(response, permissions));
                context.requestPermissions(permissionSet.toArray(new String[permissionSet.size()]), id2);
            } else {
                response.permissionGranted();
            }
        }
    }

    public static void getPermission(@NonNull Fragment context, @NonNull String[] permissions, @NonNull Response response) {
        if (Build.VERSION.SDK_INT < 23) {
            response.permissionGranted();
        } else {
            HashSet<String> permissionSet = new HashSet<String>();
            for (String permission : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context.getContext(), (String)permission) == 0) continue;
                permissionSet.add(permission);
            }
            if (permissionSet.size() > 0) {
                int id2 = 42167;
                while (map.containsKey(id2)) {
                    id2 = (int)Math.round(Math.random() * 2.147483647E9);
                }
                map.put(id2, new ResponseWrapper(response, permissions));
                context.requestPermissions(permissionSet.toArray(new String[permissionSet.size()]), id2);
            } else {
                response.permissionGranted();
            }
        }
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, @NonNull int[] grantResults) {
        ResponseWrapper responseWrapper = map.get(requestCode);
        if (responseWrapper == null) {
            return;
        }
        if (grantResults.length > 0 && grantResults[0] == 0) {
            responseWrapper.response.permissionGranted();
        } else {
            responseWrapper.response.permissionDenied();
        }
    }

    private static class ResponseWrapper {
        final Response response;
        final String[] permission;

        public ResponseWrapper(Response response, String permission) {
            this.response = response;
            this.permission = new String[]{permission};
        }

        ResponseWrapper(Response response, String[] permission) {
            this.response = response;
            this.permission = permission;
        }
    }

    public static interface Response {
        public void permissionGranted();

        public void permissionDenied();
    }
}

