/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.utils.log;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteQueryBuilder;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Debug;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Pair;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import org.json.JSONArray;
import org.json.JSONObject;
import xyz.truenight.utils.BaseApplication;
import xyz.truenight.utils.log.Tracer;

public class Dumper {
    private static final List<DumpExtension> sExtensionList;

    private Dumper() {
    }

    public static String dump(Object ... value) {
        return Dumper.dump((Object)value, new ArrayList());
    }

    public static String dump(Object value) {
        return Dumper.dump(value, new ArrayList());
    }

    public static String dump(Object value, ArrayList dumpedObjects) {
        if (value == null) {
            return "null";
        }
        for (Object dumpedItem : dumpedObjects) {
            if (dumpedItem != value) continue;
            return String.format("duplicate %s@%s", value.getClass().getName(), Integer.toHexString(value.hashCode()));
        }
        if (value == dumpedObjects) {
            return String.format("duplicate %s@%s", value.getClass().getName(), Integer.toHexString(value.hashCode()));
        }
        dumpedObjects.add(value);
        String result = null;
        for (DumpExtension extension : sExtensionList) {
            if (!extension.canDump(value)) continue;
            result = extension.dumpImpl(value, dumpedObjects);
            break;
        }
        dumpedObjects.remove(value);
        return result != null ? result : value.toString();
    }

    static {
        ArrayList<DumpExtension> extensions = new ArrayList<DumpExtension>();
        extensions.add(new AndroidDumpExtension());
        extensions.add(new DefaultDumpExtension());
        sExtensionList = Collections.unmodifiableList(extensions);
    }

    public static class DumpReceiver
    extends BroadcastReceiver {
        private static volatile DumpReceiver INSTANCE;
        private final BaseApplication context;
        public static final String ACTION_DUMP_GUI = "DUMP_GUI";
        public static final String ACTION_DUMP_GUI_DETAILED = "DUMP_GUI_DETAILED";
        public static final String ACTION_DUMP_THREADS = "DUMP_THREADS";
        public static final String ACTION_DUMP_FILES = "DUMP_FILES";

        private DumpReceiver(BaseApplication context) {
            this.context = context;
        }

        public IntentFilter getIntentFilter() {
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_DUMP_GUI);
            filter.addAction(ACTION_DUMP_GUI_DETAILED);
            filter.addAction(ACTION_DUMP_THREADS);
            filter.addAction(ACTION_DUMP_FILES);
            return filter;
        }

        public void onReceive(Context context, Intent intent) {
            try {
                this.dumpByAction(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void dumpByAction(Intent intent) {
            Tracer.print((Object)Dumper.dump((Object)intent));
            switch (intent.getAction()) {
                case "DUMP_GUI": {
                    Tracer.print((Object)DumpUtils.dumpActivity(this.context.topActivity()));
                    break;
                }
                case "DUMP_GUI_DETAILED": {
                    Tracer.print((Object)DumpUtils.dumpViewHierarchy(this.context.topActivity()));
                    break;
                }
                case "DUMP_THREADS": {
                    Tracer.print((Object)DumpUtils.dumpThreads());
                    break;
                }
                case "DUMP_FILES": {
                    Tracer.print((Object)("\n" + DumpUtils.Dir.listFiles(this.context.getCacheDir().getParent())));
                }
            }
        }

        public void register() {
            this.getContext().registerReceiver((BroadcastReceiver)this, this.getIntentFilter());
        }

        public void unregister() {
            try {
                this.getContext().unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DumpReceiver get(BaseApplication context) {
            Class<DumpReceiver> clazz = DumpReceiver.class;
            synchronized (DumpReceiver.class) {
                if (INSTANCE == null) {
                    INSTANCE = new DumpReceiver(context);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
        }

        private Context getContext() {
            return this.context;
        }
    }

    public static class ReflectionHelper {
        private static final AtomicBoolean sPrintLog = new AtomicBoolean(false);

        public static void setPrintLog(boolean print) {
            sPrintLog.set(print);
        }

        public static <T> T getInstance(String className) {
            T result = null;
            try {
                Class<?> c = Class.forName(className);
                result = (T)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                Tracer.w("Filed instantiate " + className, e);
            }
            catch (InstantiationException e) {
                Tracer.w("Filed instantiate " + className, e);
            }
            catch (IllegalAccessException e) {
                Tracer.w("Filed instantiate " + className, e);
            }
            return result;
        }

        public static <T> T getInstanceUnsafe(String className) throws Exception {
            Class<?> c = Class.forName(className);
            Object result = c.newInstance();
            return (T)result;
        }

        public static Object callMethod(Object object, String methodName, Object ... args) {
            return ReflectionHelper.callMethod(object.getClass(), object, methodName, args);
        }

        public static Object callMethod(Class<?> c, String methodName, Object ... args) {
            return ReflectionHelper.callMethod(c, null, methodName, args);
        }

        public static Object callMethod(Class<?> c, Object obj, String methodName, Object[] args) {
            Object result = null;
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            result = ReflectionHelper.callMethodTyped(c, obj, methodName, argTypes, args);
            return result;
        }

        public static Object callMethodVarArgs(Class<?> c, Object obj, String methodName, Object[] args, Object varArgs) {
            Object result = null;
            Class[] argTypes = new Class[args.length + 1];
            Object[] allArgs = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
                allArgs[i] = args[i];
            }
            argTypes[args.length] = varArgs.getClass();
            allArgs[args.length] = varArgs;
            result = ReflectionHelper.callMethodTyped(c, obj, methodName, argTypes, allArgs);
            return result;
        }

        public static Object callMethodTyped(Class<?> c, Object obj, String methodName, Class<?>[] argTypes, Object[] args) {
            if (obj != null && obj.getClass() != c) {
                throw new IllegalStateException();
            }
            Object result = null;
            try {
                if (sPrintLog.get()) {
                    Tracer.print((Object)ReflectionHelper.getMethodStr(methodName, argTypes));
                }
                Method method = c.getDeclaredMethod(methodName, argTypes);
                method.setAccessible(true);
                result = method.invoke(obj, args);
            }
            catch (InvocationTargetException e) {
                Tracer.e(e);
            }
            catch (NoSuchMethodException e) {
                Tracer.e(e);
            }
            catch (IllegalAccessException e) {
                Tracer.e(e);
            }
            return result;
        }

        public static String getMethodStr(String methodName, Class<?>[] argTypes) {
            return String.format("%s(%s)", methodName, ReflectionHelper.getTypesStr(argTypes));
        }

        public static String getTypesStr(Class<?>[] types) {
            if (types.length == 0) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            ReflectionHelper.appendTypeName(result, types[0]);
            for (int i = 1; i < types.length; ++i) {
                result.append(',');
                ReflectionHelper.appendTypeName(result, types[i]);
            }
            return result.toString();
        }

        public static void appendTypeName(StringBuilder out, Class<?> c) {
            int dimensions = 0;
            while (c.isArray()) {
                c = c.getComponentType();
                ++dimensions;
            }
            out.append(c.getName());
            for (int d = 0; d < dimensions; ++d) {
                out.append("[]");
            }
        }

        public static <T> T getField(Object object, String fieldName, Class<T> tClass) {
            return (T)ReflectionHelper.getField(object, fieldName);
        }

        public static Object getField(Object object, String fieldName) {
            try {
                Class<?> c = object.getClass();
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (IllegalAccessException e) {
                Tracer.e(e);
            }
            catch (NoSuchFieldException e) {
                Tracer.e(e);
            }
            return null;
        }

        public static <T> T getField(Class<?> \u0441, String fieldName, Class<T> tClass) {
            return (T)ReflectionHelper.getField(\u0441, fieldName);
        }

        public static Object getField(Class<?> c, String fieldName) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                Tracer.e(e);
            }
            catch (NoSuchFieldException e) {
                Tracer.e(e);
            }
            return null;
        }

        public static <T> T proxy(T originObject) {
            Class[] interfaces = new Class[]{Serializable.class};
            Object proxy = Proxy.newProxyInstance(originObject.getClass().getClassLoader(), interfaces, (InvocationHandler)new DefaultHandler(originObject));
            return (T)proxy;
        }

        public static Class<?> getClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionHelper.getClass(((ParameterizedType)type).getRawType());
            }
            if (type instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)type).getGenericComponentType();
                Class<?> componentClass = ReflectionHelper.getClass(componentType);
                if (componentClass != null) {
                    return Array.newInstance(componentClass, 0).getClass();
                }
                return null;
            }
            return null;
        }

        public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
            HashMap resolvedTypes = new HashMap();
            Type type = childClass;
            while (!ReflectionHelper.getClass(type).equals(baseClass)) {
                if (type instanceof Class) {
                    type = type.getGenericSuperclass();
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                }
                if (rawType.equals(baseClass)) continue;
                type = rawType.getGenericSuperclass();
            }
            Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
            ArrayList typeArgumentsAsClasses = new ArrayList();
            for (Type baseType : actualTypeArguments) {
                while (resolvedTypes.containsKey(baseType)) {
                    baseType = (Type)resolvedTypes.get(baseType);
                }
                typeArgumentsAsClasses.add(ReflectionHelper.getClass(baseType));
            }
            return typeArgumentsAsClasses;
        }

        public static Class<?> getRawType(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                ReflectionHelper.checkArgument(rawType instanceof Class);
                return (Class)rawType;
            }
            if (type instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)type).getGenericComponentType();
                return Array.newInstance(ReflectionHelper.getRawType(componentType), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (type instanceof WildcardType) {
                return ReflectionHelper.getRawType(((WildcardType)type).getUpperBounds()[0]);
            }
            String className = type == null ? "null" : type.getClass().getName();
            throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
        }

        private static void checkArgument(boolean condition) {
            if (!condition) {
                throw new IllegalArgumentException();
            }
        }

        public static boolean equals(Type type, Class<?> clazz) {
            return ReflectionHelper.getRawType(type) == clazz;
        }

        private static class DefaultHandler
        implements InvocationHandler {
            private final Object mOriginObject;

            public <T> DefaultHandler(T originObject) {
                this.mOriginObject = originObject;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Tracer.print((Object)("proxy = " + proxy + " method = " + method + " args = " + Dumper.dump(args)));
                return method.invoke(this.mOriginObject, args);
            }
        }
    }

    private static class ObjectDumper {
        private ObjectDumper() {
        }

        public static String dumpFields(Object object) {
            StringBuilder sb = new StringBuilder();
            ObjectDumper.dumpFields(sb, object, new ArrayList());
            return sb.toString();
        }

        public static void dumpFields(StringBuilder sb, Object object, ArrayList dumpedObjects) {
            Class<?> oClass;
            if (object == null) {
                sb.append("null");
                return;
            }
            for (Object dumpedItem : dumpedObjects) {
                if (dumpedItem != object) continue;
                sb.append("duplicate " + object.getClass().getName() + "@" + Integer.toHexString(object.hashCode()));
                return;
            }
            if (object == dumpedObjects) {
                sb.append("duplicate " + object.getClass().getName() + "@" + Integer.toHexString(object.hashCode()));
                return;
            }
            dumpedObjects.add(object);
            Class<?> clazz = oClass = object != null ? object.getClass() : null;
            if (object == null) {
                sb.append("null");
            } else if (oClass.isArray()) {
                sb.append("Array: ");
                sb.append("[");
                for (int i = 0; i < Array.getLength(object); ++i) {
                    Object value = Array.get(object, i);
                    if (value != null) {
                        if (value.getClass().isPrimitive() || value.getClass() == Long.class || value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == Double.class || value.getClass() == Float.class || value.getClass() == Short.class || value.getClass() == Character.class || value.getClass() == Byte.class) {
                            sb.append(value);
                            if (i == Array.getLength(object) - 1) continue;
                            sb.append(",");
                            continue;
                        }
                        if (value.getClass() == String.class) {
                            String str = (String)value;
                            sb.append(str != null && str.length() > 1000 ? str.substring(0, 1000) : str);
                            if (i == Array.getLength(object) - 1) continue;
                            sb.append(",");
                            continue;
                        }
                        ObjectDumper.dumpFields(sb, value, dumpedObjects);
                        continue;
                    }
                    sb.append("null");
                }
                sb.append("]\n");
            } else {
                sb.append("Class: " + oClass.getName());
                sb.append("{\n");
                while (oClass != null) {
                    Field[] fields = oClass.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        fields[i].setAccessible(true);
                        sb.append(fields[i].getName());
                        sb.append("=");
                        try {
                            Object value = fields[i].get(object);
                            if (value != null) {
                                if (value.getClass().isPrimitive() || value.getClass() == Long.class || value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == Double.class || value.getClass() == Float.class || value.getClass() == Short.class || value.getClass() == Character.class || value.getClass() == Byte.class) {
                                    sb.append(value);
                                } else if (value.getClass() == String.class) {
                                    String str = (String)value;
                                    sb.append(str != null && str.length() > 1000 ? str.substring(0, 1000) : str);
                                } else {
                                    sb.append(Dumper.dump(value, dumpedObjects));
                                }
                            } else {
                                sb.append("null");
                            }
                        }
                        catch (IllegalAccessException e) {
                            sb.append(e.getMessage());
                        }
                        sb.append("\n");
                    }
                    oClass = oClass.getSuperclass();
                }
                sb.append("}\n");
            }
            dumpedObjects.remove(object);
        }

        public static String dumpMethods(Object object) {
            StringBuilder sb = new StringBuilder();
            ObjectDumper.dumpMethods(sb, object);
            return sb.toString();
        }

        public static String dumpMethods(Class<?> clazz) {
            StringBuilder sb = new StringBuilder();
            ObjectDumper.dumpMethods(sb, clazz);
            return sb.toString();
        }

        public static void dumpMethods(StringBuilder sb, Object object) {
            Class<?> clazz = object != null ? object.getClass() : null;
            ObjectDumper.dumpMethods(sb, clazz);
        }

        public static void dumpMethods(StringBuilder sb, Class<?> clazz) {
            if (clazz == null) {
                sb.append("null");
            } else {
                for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                    sb.append('\n').append('\n').append(clazz.getName()).append(" methods:").append('\n');
                    for (Method method : c.getDeclaredMethods()) {
                        sb.append(method);
                        sb.append('\n');
                    }
                }
                sb.append('\n');
            }
        }
    }

    public static class DateTimeHelper {
        public static final long SECOND = 1000L;
        public static final long MINUTE = 60000L;
        public static final long HOUR = 3600000L;
        public static final long DAY = 86400000L;
        public static final long DAYS_30 = 2592000000L;
        public static final long LAST_MS_IN_SEC = 999L;

        public static String getMsDuration(double time) {
            String prefix = "";
            if (time < 0.0) {
                prefix = "-";
                time = -time;
            }
            int percents = (int)(time * 100.0 % 100.0);
            return prefix + (long)time + "." + (percents < 10 ? "0" + percents : Integer.valueOf(percents));
        }

        public static String getSecondDuration(long time) {
            String prefix = "";
            if (time < 0L) {
                prefix = "-";
                time = -time;
            }
            long ms = time % 1000L;
            long sec = time / 1000L;
            String seconds = "" + (sec < 10L ? "0" + sec : Long.valueOf(sec));
            return prefix + seconds + "." + (ms < 10L ? "00" + ms : (ms < 100L ? "0" + ms : Long.valueOf(ms)));
        }

        public static String getDuration(long time) {
            return DateTimeHelper.getDuration(time, true);
        }

        public static String getDuration(long time, boolean showMs) {
            String prefix = "";
            if (time < 0L) {
                prefix = "-";
                time = -time;
            }
            long ms = time % 1000L;
            long sec = time / 1000L;
            long hours = sec / 3600L;
            long min = (sec %= 3600L) / 60L;
            String withoutMs = "" + (hours < 10L ? "0" + hours : Long.valueOf(hours)) + ":" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec %= 60L));
            if (showMs) {
                return prefix + withoutMs + "." + (ms < 10L ? "00" + ms : (ms < 100L ? "0" + ms : Long.valueOf(ms)));
            }
            return prefix + withoutMs;
        }

        public static String getDurationMinutes(long time) {
            return DateTimeHelper.getDurationMinutes(time, true);
        }

        public static String getDurationMinutes(long time, boolean showMs) {
            long ms = time % 1000L;
            long sec = time / 1000L;
            long min = sec / 60L;
            String withoutMs = "" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec %= 60L));
            if (showMs) {
                return withoutMs + ":" + (ms < 10L ? "00" + ms : (ms < 100L ? "0" + ms : Long.valueOf(ms)));
            }
            return withoutMs;
        }

        public static String getDate() {
            return DateTimeHelper.getDate(System.currentTimeMillis());
        }

        public static String getDate(long time) {
            return new SimpleDateFormat("yyyy MM dd HH:mm:ss:SSS", Locale.getDefault()).format(time);
        }

        public static String getFileDate() {
            return DateTimeHelper.getFileDate(System.currentTimeMillis());
        }

        private static String getFileDate(long time) {
            return new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS", Locale.getDefault()).format(time);
        }

        public static String getTime() {
            return DateTimeHelper.getTime(System.currentTimeMillis(), true);
        }

        public static String getTime(long time) {
            return DateTimeHelper.getTime(time, true);
        }

        public static String getTime(boolean showMs) {
            return DateTimeHelper.getTime(System.currentTimeMillis(), showMs);
        }

        private static String getTime(long time, boolean showMs) {
            if (showMs) {
                return new SimpleDateFormat("HH:mm:ss:SSS", Locale.getDefault()).format(time);
            }
            return new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(time);
        }

        public static String getDateTimeInPreferredFormat(Context context, long date) {
            StringBuilder sb = new StringBuilder().append(DateTimeHelper.getDateInPreferredFormat(context, date)).append(' ').append(DateTimeHelper.getTimeInPreferredFormat(context, date));
            return sb.toString();
        }

        public static String getDateInPreferredFormat(Context context, long date) {
            return DateFormat.getDateFormat((Context)context).format(date);
        }

        public static String getTimeInPreferredFormat(Context context, long date) {
            return DateFormat.getTimeFormat((Context)context).format(date);
        }

        public static long getYesterdayTime() {
            Calendar date = DateTimeHelper.getMidnight();
            date.add(5, -1);
            return date.getTimeInMillis();
        }

        public static long getNewYearTime() {
            Calendar date = DateTimeHelper.getMidnight();
            date.set(2, 0);
            date.set(5, 1);
            return date.getTimeInMillis();
        }

        public static long getMidnightTime() {
            return DateTimeHelper.getMidnight().getTimeInMillis();
        }

        private static Calendar getMidnight() {
            GregorianCalendar date = new GregorianCalendar();
            date.set(11, 0);
            date.set(12, 0);
            date.set(13, 0);
            date.set(14, 0);
            return date;
        }

        public static String getDateNoYearFromPreferredFormat(Context context, long date) {
            String dateStr = DateTimeHelper.getDateInPreferredFormat(context, date);
            try {
                char[] order = DateFormat.getDateFormatOrder((Context)context);
                if (order[0] == 'Y' || order[0] == 'y') {
                    char firstChar;
                    dateStr = dateStr.substring(4);
                    while ((firstChar = dateStr.charAt(0)) == ' ' || firstChar == '/' || firstChar == '\\' || firstChar == '.' || firstChar == ',') {
                        dateStr = dateStr.substring(1);
                    }
                } else {
                    char lastChar;
                    dateStr = dateStr.substring(0, dateStr.length() - 5);
                    while ((lastChar = dateStr.charAt(dateStr.length() - 1)) == ' ' || lastChar == '/' || lastChar == '\\' || lastChar == '.' || lastChar == ',') {
                        dateStr = dateStr.substring(0, dateStr.length() - 2);
                    }
                }
            }
            catch (Exception e) {
                Tracer.e(e);
            }
            return dateStr == null ? "" : dateStr;
        }

        public static String getAppFormattedDateTime(long time, Context context, int resId) {
            String date = "";
            if (time > DateTimeHelper.getMidnightTime()) {
                date = DateTimeHelper.getTimeInPreferredFormat(context, time);
            } else if (time > DateTimeHelper.getYesterdayTime()) {
                String timeString = DateTimeHelper.getTimeInPreferredFormat(context, time);
                date = context.getString(resId, new Object[]{timeString});
            } else {
                date = time > DateTimeHelper.getNewYearTime() ? DateTimeHelper.getDateNoYearFromPreferredFormat(context, time) + " " + DateTimeHelper.getTimeInPreferredFormat(context, time) : DateTimeHelper.getDateTimeInPreferredFormat(context, time);
            }
            return date;
        }

        public static String getDateTimeInPreferredFormat(Context context) {
            long currentTimeMillis = System.currentTimeMillis();
            return DateTimeHelper.getDateTimeInPreferredFormat(context, currentTimeMillis);
        }
    }

    private static class FileHelper {
        private FileHelper() {
        }

        public static String[] list(File dir, FileFilter filter) {
            ArrayList<String> list = new ArrayList<String>();
            File[] fileArr = dir.listFiles(filter);
            if (fileArr != null) {
                for (File f : fileArr) {
                    list.add(f.getName());
                }
            }
            return list.toArray(new String[list.size()]);
        }
    }

    public static class DumpUtils {
        public static String toString(Object obj, int maxLength) {
            return TextHelper.ellipsize(String.valueOf(obj), maxLength);
        }

        public static String dumpFields(Object obj) {
            return ObjectDumper.dumpFields(obj);
        }

        public static String dumpProperties() {
            return Dumper.dump((Object)System.getProperties());
        }

        public static String dumpSize(Collection collection) {
            return collection == null ? "null" : "" + collection.size();
        }

        public static String dumpChars(String s) {
            if (s == null) {
                return "null";
            }
            char[] chars = s.toCharArray();
            StringBuilder sb = new StringBuilder();
            sb.append("string chars:\n");
            sb.append("string = " + s).append("\n");
            sb.append("count = " + s.length()).append("\n");
            sb.append("string chars:\n");
            sb.append("chars = " + Dumper.dump((Object)chars)).append("\n");
            ArrayList<String> list = new ArrayList<String>();
            for (char curChar : chars) {
                list.add(String.format("%04x", curChar));
            }
            sb.append("chars(hex) = " + list).append("\n");
            list.clear();
            for (char curChar : chars) {
                list.add(String.valueOf((int)curChar));
            }
            sb.append("chars(decimal) = " + list).append("\n");
            return sb.toString();
        }

        public static String dumpViewState(View ... views) {
            StringBuilder sb = new StringBuilder();
            sb.append("view info: ");
            for (View view : views) {
                if (view == null) {
                    sb.append("null\n\n");
                    continue;
                }
                sb.append("\n").append(view.getClass().getName()).append(" @+id/").append(DumpUtils.getViewName(view)).append(" ").append(DumpUtils.getViewVisibility(view)).append("\n").append("alpha = ").append(view.getAlpha()).append("\n").append("size = ").append("(" + view.getWidth() + ";" + view.getHeight() + ")").append("\n").append("location = ").append(DumpUtils.getViewRect(view)).append("\n");
                if (!(view instanceof TextView)) continue;
                TextView textView = (TextView)view;
                String text = textView.getText().toString();
                float px = textView.getTextSize();
                int dp = DumpUtils.pxToDp(textView.getContext(), px);
                sb.append("text = ").append(DumpUtils.ellipsize(text, 10)).append("\n").append("text size(dp) = ").append(dp).append("\n").append("text size(px) = ").append(px).append("\n");
            }
            return sb.toString().trim();
        }

        public static int pxToDp(Context context, float px) {
            float scale = context.getResources().getDisplayMetrics().density;
            return Math.round(px / scale);
        }

        public static String getResName(Context ctx, int resId) {
            try {
                return ctx.getResources().getResourceEntryName(resId);
            }
            catch (Resources.NotFoundException e) {
                return "Resource not found";
            }
        }

        public static Rect getViewRect(View view) {
            int[] l = new int[2];
            view.getLocationOnScreen(l);
            return new Rect(l[0], l[1], l[0] + view.getWidth(), l[1] + view.getHeight());
        }

        public static String getViewName(View view) {
            int viewId = view.getId();
            if (viewId == -1) {
                return "No id";
            }
            return DumpUtils.getResName(view.getContext(), viewId);
        }

        public static String getViewVisibility(View view) {
            String visibilityStr;
            int visibility = view.getVisibility();
            switch (visibility) {
                case 0: {
                    visibilityStr = "VISIBLE";
                    break;
                }
                case 4: {
                    visibilityStr = "INVISIBLE";
                    break;
                }
                case 8: {
                    visibilityStr = "GONE";
                    break;
                }
                default: {
                    visibilityStr = "unknown(" + visibility + ")";
                }
            }
            return visibilityStr;
        }

        public static String dumpActivity(Activity activity) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nactivity: ").append(activity.getClass());
            if (activity instanceof FragmentActivity) {
                sb.append("\nfragments: ").append(Dumper.dump(DumpUtils.getAllFragments((FragmentActivity)activity)));
            }
            return sb.toString();
        }

        public static List<Fragment> getAllFragments(FragmentActivity activity) {
            List allFragments = activity.getSupportFragmentManager().getFragments();
            if (allFragments == null || allFragments.isEmpty()) {
                return Collections.emptyList();
            }
            return allFragments;
        }

        public static String dumpViewHierarchy(Activity activity) {
            return DumpUtils.dumpActivity(activity) + DumpUtils.dumpViewHierarchy(activity.findViewById(0x1020002).getRootView());
        }

        public static String dumpViewHierarchy(View view) {
            StringBuilder sb = new StringBuilder();
            DumpUtils.dumpViewHierarchy(sb, view, "", -1);
            return sb.toString();
        }

        private static void dumpViewHierarchy(StringBuilder sb, View view, String indent, int position) {
            sb.append('\n');
            int startPosition = sb.length();
            sb.append(indent).append("* ");
            indent = sb.substring(startPosition);
            if (position >= 0) {
                sb.append(position).append(':');
            }
            if (view != null) {
                Resources resources = view.getContext().getResources();
                sb.append(view.getClass().getName());
                int id2 = view.getId();
                if (id2 != -1) {
                    if (resources != null) {
                        sb.append(" @+id/").append(resources.getResourceEntryName(id2));
                    }
                } else {
                    sb.append(" NO_ID");
                }
            } else {
                sb.append("null");
            }
            if (view instanceof TextView) {
                sb.append(" ").append(DumpUtils.ellipsize(((TextView)view).getText().toString(), 10));
            }
            sb.append(" ").append(DumpUtils.getViewVisibility(view)).append(" ").append("alpha = ").append(view.getAlpha()).append(" ").append("size = ").append("(" + view.getWidth() + ";" + view.getHeight() + ")").append(" ").append("location = ").append(DumpUtils.getViewRect(view));
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int childCount = group.getChildCount();
                sb.append('\n').append(indent).append("\\/==subviews(").append(childCount).append(")==\\/").append("\n").append(indent).append("{");
                for (int i = 0; i < childCount; ++i) {
                    DumpUtils.dumpViewHierarchy(sb, group.getChildAt(i), indent, i);
                }
                sb.append('\n').append(indent).append("}").append('\n').append(indent).append("/\\==subviews(").append(childCount).append(")==/\\");
            }
        }

        private static String ellipsize(String s, int maxLength) {
            return s != null && s.length() > maxLength ? s.substring(0, maxLength) + "..." : s;
        }

        public static String dumpThreads() {
            return DumpUtils.dumpThreads(true);
        }

        public static String dumpThreads(boolean full) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            Set<Thread> threadSet = allStackTraces.keySet();
            Set<Map.Entry<Thread, StackTraceElement[]>> set = allStackTraces.entrySet();
            StringBuilder sb = new StringBuilder();
            sb.append("Threads state. count: " + threadSet.size()).append('\n');
            for (Map.Entry<Thread, StackTraceElement[]> entry : set) {
                Thread thread = entry.getKey();
                sb.append(Dumper.dump((Object)thread));
                if (!full) continue;
                StackTraceElement[] stackTrace = entry.getValue();
                if (stackTrace == null) {
                    sb.append("\nin\n(unknown)");
                } else {
                    sb.append("\nin\n");
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        sb.append(stackTraceElement.toString()).append('\n');
                    }
                    sb.append('\n').append('=');
                }
                sb.append('\n').append('\n');
            }
            return sb.toString();
        }

        public static String dumpThread(boolean full) {
            return DumpUtils.dumpThread(Thread.currentThread(), full);
        }

        public static String dumpThread(Thread thread, boolean full) {
            StringBuilder sb = new StringBuilder();
            sb.append(Dumper.dump((Object)thread));
            if (full) {
                StackTraceElement[] stackTrace = thread.getStackTrace();
                if (stackTrace == null) {
                    sb.append("\nin\n(unknown)");
                } else {
                    sb.append("\nin\n");
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        sb.append(stackTraceElement.toString()).append('\n');
                    }
                    sb.append('\n').append('=');
                }
                sb.append('\n').append('\n');
            }
            return sb.toString();
        }

        public static String dumpTrimMemory(int level) {
            switch (level) {
                case 40: {
                    return "TRIM_MEMORY_BACKGROUND";
                }
                case 80: {
                    return "TRIM_MEMORY_COMPLETE";
                }
                case 60: {
                    return "TRIM_MEMORY_MODERATE";
                }
                case 15: {
                    return "TRIM_MEMORY_RUNNING_CRITICAL";
                }
                case 10: {
                    return "TRIM_MEMORY_RUNNING_LOW";
                }
                case 5: {
                    return "TRIM_MEMORY_RUNNING_MODERATE";
                }
                case 20: {
                    return "TRIM_MEMORY_UI_HIDDEN";
                }
            }
            return "unknown";
        }

        public static class Dir {
            public static final char GO_TO_NEXT_LINE = '\n';
            public static final String F_PREFIX = "[F] : ";
            public static final String D_PREFIX = "[D] : ";
            private static final String FILE_LISTING = " file listing...";
            private static final String EITHER_DIRECTORY_DOES_NOT_EXIST_OR_IS_NOT_A_DIRECTORY = "Either directory does not exist or is not a directory";
            private static final String ERROR_WITH = "Error with ";
            private static final String BYTES = " bytes";
            private static final String SPACE = " ";
            private static final String LINE_SEPARATOR = "----------------------";
            private static final char D_CHAR = 'D';
            private static final StringBuilder sb = new StringBuilder();

            private static void doFileFilterListing(String dirName, String ff) {
                if (dirName == null) {
                    return;
                }
                Dir.println(LINE_SEPARATOR);
                Dir.print(dirName);
                Dir.println(FILE_LISTING);
                Dir.println(LINE_SEPARATOR);
                final String fileFilter = ff;
                File dir = new File(dirName);
                FileFilter filter = null;
                if (fileFilter != null) {
                    filter = new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            String name = file.getName();
                            return name.startsWith(fileFilter);
                        }
                    };
                }
                String[] children = FileHelper.list(dir, filter);
                Dir.printFiles(children, dirName);
                File[] listFiles = dir.listFiles();
                if (listFiles != null) {
                    for (File f : listFiles) {
                        if (f == null || !f.exists() || !f.isDirectory()) continue;
                        Dir.doFileFilterListing(f.getAbsolutePath(), ff);
                    }
                }
            }

            private static void printFiles(String[] children, String dirName) {
                if (children == null) {
                    Dir.print(ERROR_WITH);
                    Dir.println(dirName);
                    Dir.println(EITHER_DIRECTORY_DOES_NOT_EXIST_OR_IS_NOT_A_DIRECTORY);
                } else {
                    for (int i = 0; i < children.length; ++i) {
                        String filename = children[i];
                        if (filename == null) continue;
                        File file = new File(dirName, filename);
                        if (file.isDirectory()) {
                            Dir.print(D_PREFIX);
                            Dir.print(dirName);
                            Dir.print(File.separator);
                            Dir.println(filename);
                            continue;
                        }
                        Dir.print(F_PREFIX);
                        Dir.print(dirName);
                        Dir.print(File.separator);
                        Dir.print(filename);
                        Dir.print(SPACE);
                        Dir.print(file.length());
                        Dir.println(BYTES);
                    }
                }
            }

            private static void println(String string) {
                sb.append(string).append('\n');
            }

            private static void print(String string) {
                sb.append(string);
            }

            private static void print(long l) {
                sb.append(l);
            }

            public static String listFiles(File dir) {
                String result = "";
                if (dir != null) {
                    sb.setLength(0);
                    Dir.doFileFilterListing(dir.getAbsolutePath(), null);
                    result = sb.toString();
                    sb.setLength(0);
                }
                return result;
            }

            public static String listFiles(String dirName) {
                String result = "";
                if (dirName != null) {
                    sb.setLength(0);
                    Dir.doFileFilterListing(dirName, null);
                    result = sb.toString();
                    sb.setLength(0);
                }
                return result;
            }

            public static String listFiles(String[] dirNames) {
                String result = "";
                if (dirNames != null) {
                    sb.setLength(0);
                    for (int i = 0; i < dirNames.length; ++i) {
                        sb.append('D').append(i).append('\n');
                        Dir.doFileFilterListing(dirNames[i], null);
                    }
                    result = sb.toString();
                    sb.setLength(0);
                }
                return result;
            }
        }

        public static class ConvertCollections {
            public static HashMap<String, Object> toHashMap(Bundle bundle) {
                if (bundle == null) {
                    return null;
                }
                Set keys = bundle.keySet();
                HashMap<String, Object> hm = new HashMap<String, Object>();
                for (String key : keys) {
                    hm.put(key, bundle.get(key));
                }
                return hm;
            }
        }

        public static class Sql {
            public static String query(Uri uri, String[] columns, String selection, String[] selectionArgs, String orderBy) {
                String table = uri.toString();
                return Sql.query(table, columns, selection, selectionArgs, null, null, orderBy, null, null);
            }

            public static String query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
                return Sql.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, null, null);
            }

            public static String query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
                return Sql.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
            }

            public static String query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
                String result = null;
                try {
                    String sql = SQLiteQueryBuilder.buildQueryString((boolean)false, (String)table, (String[])columns, (String)selection, (String)groupBy, (String)having, (String)orderBy, (String)limit);
                    result = "query : " + sql + "\nargs : " + Arrays.toString(selectionArgs);
                }
                catch (Exception e) {
                    result = Dumper.dump((Object)e);
                }
                return result;
            }

            public static String delete(Uri uri, String selection, String[] selectionArgs) {
                String table = uri.toString();
                return Sql.delete(table, selection, selectionArgs);
            }

            public static String delete(String table, String whereClause, String[] whereArgs) {
                String sql = "DELETE FROM " + table + (!TextUtils.isEmpty((CharSequence)whereClause) ? " WHERE " + whereClause : "");
                return "query : " + sql + "\nargs:" + Arrays.toString(whereArgs);
            }

            public static String update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
                String table = uri.toString();
                return Sql.update(table, values, selection, selectionArgs);
            }

            public static String update(String table, ContentValues values, String whereClause, String[] whereArgs) {
                StringBuilder sql = new StringBuilder(120);
                sql.append("UPDATE ");
                sql.append(table);
                sql.append(" SET ");
                int setValuesSize = values.size();
                int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
                Object[] bindArgs = new Object[bindArgsSize];
                int i = 0;
                for (Map.Entry entry : values.valueSet()) {
                    sql.append(i > 0 ? "," : "");
                    sql.append((String)entry.getKey());
                    bindArgs[i++] = entry.getValue();
                    sql.append("=?");
                }
                if (whereArgs != null) {
                    for (i = setValuesSize; i < bindArgsSize; ++i) {
                        bindArgs[i] = whereArgs[i - setValuesSize];
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)whereClause)) {
                    sql.append(" WHERE ");
                    sql.append(whereClause);
                }
                return "query : " + sql + "\nargs : " + Arrays.toString(bindArgs);
            }

            public static String insert(Uri uri, ContentValues values) {
                String table = uri.toString();
                return Sql.insert(table, null, values);
            }

            public static String insert(String table, String nullColumnHack, ContentValues initialValues) {
                int size;
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT");
                sql.append(" INTO ");
                sql.append(table);
                sql.append('(');
                Object[] bindArgs = null;
                int n = size = initialValues != null && initialValues.size() > 0 ? initialValues.size() : 0;
                if (size > 0) {
                    bindArgs = new Object[size];
                    int i = 0;
                    for (Map.Entry entry : initialValues.valueSet()) {
                        sql.append(i > 0 ? "," : "");
                        sql.append((String)entry.getKey());
                        bindArgs[i++] = entry.getValue();
                    }
                    sql.append(')');
                    sql.append(" VALUES (");
                    for (i = 0; i < size; ++i) {
                        sql.append(i > 0 ? ",?" : "?");
                    }
                } else {
                    sql.append(nullColumnHack + ") VALUES (NULL");
                }
                sql.append(')');
                return "query : " + sql + "\nargs : " + Arrays.toString(bindArgs);
            }

            public static String execSQL(String sql, Object[] bindArgs) {
                return "query : " + sql + "\nargs : " + Arrays.toString(bindArgs);
            }

            public static String rawQuery(String sql, Object[] bindArgs) {
                return "query : " + sql + "\nargs : " + Arrays.toString(bindArgs);
            }
        }

        public static class Database {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressLint(value={"NewApi"})
            public static String dump(SQLiteDatabase database) {
                StringBuilder sb = new StringBuilder();
                sb.append("Database:\npath = ").append(database.getPath()).append("\n");
                sb.append("version = ").append(database.getVersion()).append("\n");
                sb.append("pageSize = ").append(database.getPageSize()).append("\n");
                sb.append("maximumSize = ").append(database.getMaximumSize()).append("\n");
                if (OsVersionHelper.have(11)) {
                    sb.append("attachedDbs = ").append(database.getAttachedDbs()).append("\n");
                }
                sb.append("isOpen = ").append(database.isOpen()).append("\n");
                sb.append("isReadOnly = ").append(database.isReadOnly()).append("\n");
                if (OsVersionHelper.have(16)) {
                    sb.append("isWriteAheadLoggingEnabled = ").append(database.isWriteAheadLoggingEnabled()).append("\n");
                }
                sb.append("inTransaction =").append(database.inTransaction()).append("\n");
                sb.append("isDbLockedByCurrentThread = ").append(database.isDbLockedByCurrentThread()).append("\n");
                if (OsVersionHelper.have(11)) {
                    sb.append("isDatabaseIntegrityOk = ").append(database.isDatabaseIntegrityOk()).append("\n");
                }
                Cursor dbMetadataCursor = null;
                try {
                    dbMetadataCursor = database.rawQuery("SELECT * FROM sqlite_master", null);
                    int columnIndex = dbMetadataCursor.getColumnIndex("name");
                    sb.append("\n\nDB metadata:\n\n");
                    Database.dumpCursorMetadata("    ", sb, dbMetadataCursor);
                    sb.append("\n\nTables:\n\n");
                    dbMetadataCursor.moveToPosition(-1);
                    while (dbMetadataCursor.moveToNext()) {
                        String table = dbMetadataCursor.getString(columnIndex);
                        sb.append("\n\ntable name = ").append(table).append("\n");
                        sb.append("columns:\n");
                        Cursor curTableCursor = null;
                        try {
                            curTableCursor = database.rawQuery("SELECT * FROM " + table, null);
                            Database.dumpCursorMetadata("    ", sb, curTableCursor);
                        }
                        catch (Exception e) {
                            Tracer.e(e);
                            sb.append("Failed dump table metadata").append("\n");
                        }
                        finally {
                            try {
                                curTableCursor.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception e) {
                    Tracer.e(e);
                    sb.append("Failed dump DB metadata").append("\n");
                }
                finally {
                    try {
                        dbMetadataCursor.close();
                    }
                    catch (Exception exception) {}
                }
                return sb.toString();
            }

            private static void dumpCursorMetadata(String linesPrefix, StringBuilder sb, Cursor cursor) {
                String[] columns = cursor.getColumnNames();
                for (int i = 0; i < columns.length; ++i) {
                    String column = columns[i];
                    sb.append(linesPrefix).append(column).append("\n");
                }
            }

            public static String dumpCursor(Context context, Uri contentUri) {
                return Database.dumpCursor(context, contentUri, null, null, null, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static String dumpCursor(Context context, Uri contentUri, String[] columns, String selection, String[] selectionArgs, String orderBy) {
                StringBuilder sb = new StringBuilder();
                sb.append(Sql.query(contentUri, columns, selection, selectionArgs, orderBy)).append("\n");
                sb.append("table name = ").append(contentUri).append("\n");
                sb.append("columns:\n");
                Cursor cursor = null;
                try {
                    cursor = context.getContentResolver().query(contentUri, columns, selection, selectionArgs, orderBy);
                    Database.dumpCursorMetadata("    ", sb, cursor);
                    sb.append("data:\n");
                    sb.append(Dumper.dump((Object)cursor));
                }
                catch (Exception e) {
                    Tracer.e(e);
                    sb.append("Failed dump cursor").append("\n");
                }
                finally {
                    try {
                        cursor.close();
                    }
                    catch (Exception exception) {}
                }
                return sb.toString();
            }

            private static enum ColumnType {
                UNKNOWN,
                FIELD_TYPE_NULL,
                FIELD_TYPE_INTEGER,
                FIELD_TYPE_FLOAT,
                FIELD_TYPE_STRING,
                FIELD_TYPE_BLOB;


                public static ColumnType getTypeById(int id2) {
                    ColumnType type = UNKNOWN;
                    switch (id2) {
                        case 0: {
                            type = FIELD_TYPE_NULL;
                            break;
                        }
                        case 1: {
                            type = FIELD_TYPE_INTEGER;
                            break;
                        }
                        case 2: {
                            type = FIELD_TYPE_FLOAT;
                            break;
                        }
                        case 3: {
                            type = FIELD_TYPE_STRING;
                            break;
                        }
                        case 4: {
                            type = FIELD_TYPE_BLOB;
                        }
                    }
                    return type;
                }

                public static String getColumnTypeString(int id2) {
                    ColumnType type = ColumnType.getTypeById(id2);
                    return "" + (type == UNKNOWN ? (Object)((Object)UNKNOWN) + "(" + id2 + ")" : type);
                }

                @SuppressLint(value={"NewApi"})
                private static String getColumnType(Cursor cursor, int index) {
                    if (OsVersionHelper.have(11)) {
                        return ColumnType.getColumnTypeString(cursor.getType(index));
                    }
                    return "Unknown(type detect available since api 11)";
                }
            }
        }
    }

    public static class TextHelper {
        public static String ellipsize(String s, int maxLength) {
            return s != null && s.length() > maxLength ? s.substring(0, maxLength) + "..." : s;
        }

        public static String removeInvisibleChars(String string) {
            return string.replaceAll("[\\p{Cs}\\p{Cc}\\p{Cf}\\p{Co}\\p{Cn}]", "");
        }

        public static String join(CharSequence delimiter, Iterable tokens) {
            StringBuilder sb = new StringBuilder();
            boolean firstTime = true;
            for (Object token : tokens) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(delimiter);
                }
                sb.append(token);
            }
            return sb.toString();
        }

        private String removeFromEnd(String source, String endStr) {
            int lastIndexOf;
            StringBuilder sb = new StringBuilder(source);
            while ((lastIndexOf = sb.lastIndexOf(endStr)) > -1 && lastIndexOf + endStr.length() == sb.length()) {
                sb.setLength(lastIndexOf);
            }
            return sb.toString();
        }

        public static String makeNotNull(String s) {
            return s != null ? s : "";
        }

        public static boolean isEmpty(String s) {
            return s == null || s.length() == 0;
        }

        public static boolean isNotEmpty(String s) {
            return !TextHelper.isEmpty(s);
        }

        public static boolean isAllEmpty(String ... strArr) {
            for (String s : strArr) {
                if (TextHelper.isEmpty(s)) continue;
                return false;
            }
            return true;
        }

        public static boolean isAllNotEmpty(String ... strArr) {
            for (String s : strArr) {
                if (!TextHelper.isEmpty(s)) continue;
                return false;
            }
            return true;
        }

        public static int getAfterSpaceIndex(String line, int startIndex) {
            int spaceIndex = line.indexOf(32, startIndex);
            if (spaceIndex >= 0) {
                try {
                    int afterSpaceIndex = spaceIndex + 1;
                    while (line.charAt(afterSpaceIndex) == ' ') {
                        ++afterSpaceIndex;
                    }
                    return afterSpaceIndex;
                }
                catch (Exception e) {
                    return -1;
                }
            }
            return -1;
        }

        public static ArrayList<String> wordWrap(String line, int lineLength) {
            if (TextHelper.isEmpty(line)) {
                throw new IllegalArgumentException("Empty line unsupported");
            }
            if (line.contains("\n")) {
                throw new IllegalArgumentException("Line with next line chars unsupported");
            }
            ArrayList<String> lines = new ArrayList<String>();
            int startIndex = 0;
            while (true) {
                int afterSpaceIndexNext;
                int afterSpaceIndex;
                if ((afterSpaceIndex = TextHelper.getAfterSpaceIndex(line, startIndex)) == -1) break;
                if (afterSpaceIndex - startIndex >= lineLength) {
                    lines.add(line.substring(startIndex, afterSpaceIndex));
                    startIndex = afterSpaceIndex;
                    continue;
                }
                while ((afterSpaceIndexNext = TextHelper.getAfterSpaceIndex(line, afterSpaceIndex)) - startIndex < lineLength && afterSpaceIndexNext != -1) {
                    afterSpaceIndex = afterSpaceIndexNext;
                }
                lines.add(line.substring(startIndex, afterSpaceIndex));
                startIndex = afterSpaceIndex;
            }
            lines.add(line.substring(startIndex));
            return lines;
        }

        public static String concat(List<String> text, boolean newLine) {
            StringBuilder sb = new StringBuilder();
            for (String string : text) {
                sb.append(string);
                if (!newLine) continue;
                sb.append("\n");
            }
            return sb.toString();
        }

        public static String humanReadableByteCount(long bytes) {
            return TextHelper.humanReadableByteCount(bytes, false);
        }

        public static String humanReadableByteCount(long bytes, boolean si) {
            int unit;
            int n = unit = si ? 1000 : 1024;
            if (bytes < (long)unit) {
                return bytes + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = "" + (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
            return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
        }
    }

    private static class OsVersionHelper {
        private OsVersionHelper() {
        }

        public static boolean have(int versionCode) {
            return Build.VERSION.SDK_INT >= versionCode;
        }

        public static int osVersion() {
            return Build.VERSION.SDK_INT;
        }
    }

    private static class DefaultDumpExtension
    extends DumpExtension {
        private DefaultDumpExtension() {
        }

        @Override
        public String dumpImpl(Object value, ArrayList dumpedObjects) {
            if (!this.canDump(value)) {
                throw new IllegalArgumentException(value.getClass().getName() + " unsupported for dump");
            }
            if (value instanceof byte[]) {
                return DefaultDumpExtension.dumpImpl((byte[])value, dumpedObjects);
            }
            if (value instanceof short[]) {
                return DefaultDumpExtension.dumpImpl((short[])value, dumpedObjects);
            }
            if (value instanceof int[]) {
                return DefaultDumpExtension.dumpImpl((int[])value, dumpedObjects);
            }
            if (value instanceof long[]) {
                return DefaultDumpExtension.dumpImpl((long[])value, dumpedObjects);
            }
            if (value instanceof float[]) {
                return DefaultDumpExtension.dumpImpl((float[])value, dumpedObjects);
            }
            if (value instanceof double[]) {
                return DefaultDumpExtension.dumpImpl((double[])value, dumpedObjects);
            }
            if (value instanceof char[]) {
                return DefaultDumpExtension.dumpImpl((char[])value, dumpedObjects);
            }
            if (value instanceof boolean[]) {
                return DefaultDumpExtension.dumpImpl((boolean[])value, dumpedObjects);
            }
            if (value instanceof Object[]) {
                return this.dumpImpl((Object[])value, dumpedObjects);
            }
            if (value instanceof Properties) {
                return this.dumpImpl((Properties)value, dumpedObjects);
            }
            if (value instanceof Collection) {
                return this.dumpImpl((Collection)value, dumpedObjects);
            }
            if (value instanceof Map) {
                return this.dumpImpl((Map)value, dumpedObjects);
            }
            if (value instanceof Map.Entry) {
                return this.dumpImpl((Map.Entry)value, dumpedObjects);
            }
            if (value instanceof Iterator) {
                return this.dumpImpl((Iterator)value, dumpedObjects);
            }
            if (value instanceof Throwable) {
                return this.dumpImpl((Throwable)value, dumpedObjects);
            }
            if (value instanceof URI) {
                return DefaultDumpExtension.dumpImpl((URI)value, dumpedObjects);
            }
            if (value instanceof ZipEntry) {
                return this.dumpImpl((ZipEntry)value, dumpedObjects);
            }
            if (value instanceof Thread) {
                return this.dumpImpl((Thread)value, dumpedObjects);
            }
            if (value instanceof ThreadGroup) {
                return this.dumpImpl((ThreadGroup)value, dumpedObjects);
            }
            throw new IllegalStateException("Failed dump " + value.getClass().getName());
        }

        @Override
        public boolean canDump(Object value) {
            if (value instanceof byte[]) {
                return true;
            }
            if (value instanceof short[]) {
                return true;
            }
            if (value instanceof int[]) {
                return true;
            }
            if (value instanceof long[]) {
                return true;
            }
            if (value instanceof float[]) {
                return true;
            }
            if (value instanceof double[]) {
                return true;
            }
            if (value instanceof char[]) {
                return true;
            }
            if (value instanceof boolean[]) {
                return true;
            }
            if (value instanceof Object[]) {
                return true;
            }
            if (value instanceof Properties) {
                return true;
            }
            if (value instanceof Collection) {
                return true;
            }
            if (value instanceof Map) {
                return true;
            }
            if (value instanceof Map.Entry) {
                return true;
            }
            if (value instanceof Iterator) {
                return true;
            }
            if (value instanceof Throwable) {
                return true;
            }
            if (value instanceof URI) {
                return true;
            }
            if (value instanceof ZipEntry) {
                return true;
            }
            if (value instanceof Thread) {
                return true;
            }
            return value instanceof ThreadGroup;
        }

        private static String dumpImpl(byte[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(short[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(int[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(long[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(float[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(double[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(char[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private static String dumpImpl(boolean[] array, ArrayList dumpedObjects) {
            return Arrays.toString(array);
        }

        private String dumpImpl(Object[] array, ArrayList dumpedObjects) {
            return this.dump(Arrays.asList(array), dumpedObjects);
        }

        private String dumpImpl(Collection<?> collection, ArrayList dumpedObjects) {
            return this.dump(collection.iterator(), dumpedObjects);
        }

        private String dumpImpl(Map<?, ?> map, ArrayList dumpedObjects) {
            return map.getClass().getSimpleName() + " " + this.dump(map.entrySet().iterator(), dumpedObjects);
        }

        private String dumpImpl(Map.Entry<?, ?> entry, ArrayList dumpedObjects) {
            return this.dump(entry.getKey(), dumpedObjects) + "=" + this.dump(entry.getValue(), dumpedObjects);
        }

        private String dumpImpl(Iterator iterator, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (iterator.hasNext()) {
                sb.append(this.dump(iterator.next(), dumpedObjects));
                while (iterator.hasNext()) {
                    sb.append(", ").append(this.dump(iterator.next(), dumpedObjects));
                }
            }
            sb.append(']');
            return sb.toString();
        }

        private String dumpImpl(Throwable ex, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            String info = null;
            try {
                info = ex.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sb.append(info).append('\n');
            StackTraceElement[] stackTrace = null;
            try {
                stackTrace = ex.getStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (stackTrace == null) {
                sb.append("null").append('\n');
            } else {
                for (StackTraceElement stackTraceElement : stackTrace) {
                    sb.append(stackTraceElement.toString()).append('\n');
                }
            }
            Throwable cause = null;
            try {
                cause = ex.getCause();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cause != null && cause != ex) {
                sb.append("Caused by: ").append('\n').append(this.dump(cause, dumpedObjects));
            }
            return sb.toString();
        }

        private static String dumpImpl(URI uri, ArrayList dumpedObjects) {
            String authority = uri.getAuthority();
            String fragment = uri.getFragment();
            String host = uri.getHost();
            String path = uri.getPath();
            int port = uri.getPort();
            String query = uri.getQuery();
            String encodedAuthority = uri.getRawAuthority();
            String encodedFragment = uri.getRawFragment();
            String encodedPath = uri.getRawPath();
            String encodedQuery = uri.getRawQuery();
            String encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
            String encodedUserInfo = uri.getRawUserInfo();
            String scheme = uri.getScheme();
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            String userInfo = uri.getUserInfo();
            String toASCIIString = uri.toASCIIString();
            String normalize = uri.normalize().toString();
            String normalizeScheme = null;
            String lastPathSegment = null;
            Object pathSegments = null;
            boolean isAbsolute = uri.isAbsolute();
            boolean isOpaque = uri.isOpaque();
            Object isHierarchical = null;
            Object isRelative = null;
            Object queryParameterNames = null;
            StringBuilder sb = new StringBuilder();
            sb.append(uri);
            sb.append("\n");
            sb.append(" authority = ").append(authority);
            sb.append("\n");
            sb.append(" encodedAuthority = ").append(encodedAuthority);
            sb.append("\n");
            sb.append(" encodedFragment = ").append(encodedFragment);
            sb.append("\n");
            sb.append(" encodedPath = ").append(encodedPath);
            sb.append("\n");
            sb.append(" encodedQuery = ").append(encodedQuery);
            sb.append("\n");
            sb.append(" encodedSchemeSpecificPart = ").append(encodedSchemeSpecificPart);
            sb.append("\n");
            sb.append(" encodedUserInfo = ").append(encodedUserInfo);
            sb.append("\n");
            sb.append(" fragment = ").append(fragment);
            sb.append("\n");
            sb.append(" host = ").append(host);
            sb.append("\n");
            sb.append(" lastPathSegment = ").append(lastPathSegment);
            sb.append("\n");
            sb.append(" path = ").append(path);
            sb.append("\n");
            sb.append(" pathSegments = ").append((Object)pathSegments);
            sb.append("\n");
            sb.append(" port = ").append(port);
            sb.append("\n");
            sb.append(" query = ").append(query);
            sb.append("\n");
            sb.append(" queryParameterNames = ").append((Object)queryParameterNames);
            sb.append("\n");
            sb.append(" scheme = ").append(scheme);
            sb.append("\n");
            sb.append(" schemeSpecificPart = ").append(schemeSpecificPart);
            sb.append("\n");
            sb.append(" userInfo = ").append(userInfo);
            sb.append("\n");
            sb.append(" toASCIIString = ").append(toASCIIString);
            sb.append("\n");
            sb.append(" normalize = ").append(normalize);
            sb.append("\n");
            sb.append(" normalizeScheme = ").append(normalizeScheme);
            sb.append("\n");
            sb.append(" isAbsolute = ").append(isAbsolute);
            sb.append("\n");
            sb.append(" isOpaque = ").append(isOpaque);
            sb.append("\n");
            sb.append(" isHierarchical = ").append((Object)isHierarchical);
            sb.append("\n");
            sb.append(" isRelative = ").append((Object)isRelative);
            sb.append("\n");
            return sb.toString();
        }

        private String dumpImpl(ZipEntry zipEntry, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append("ZipEntry [");
            sb.append("\n").append("class = " + zipEntry.getClass());
            sb.append("\n").append("name = " + zipEntry.getName());
            sb.append("\n").append("isDirectory = " + zipEntry.isDirectory());
            sb.append("\n").append("comment = " + zipEntry.getComment());
            sb.append("\n").append("compressedSize = " + zipEntry.getCompressedSize());
            sb.append("\n").append("crc = " + zipEntry.getCrc());
            sb.append("\n").append("extra = " + zipEntry.getExtra());
            sb.append("\n").append("method = " + zipEntry.getMethod());
            sb.append("\n").append("size = " + zipEntry.getSize());
            sb.append("\n").append("time = " + zipEntry.getTime());
            sb.append("\n").append("]");
            return sb.toString();
        }

        private String dumpImpl(Properties properties, ArrayList dumpedObjects) {
            Set<String> keys = properties.stringPropertyNames();
            HashMap<String, String> hm = new HashMap<String, String>();
            for (String key : keys) {
                hm.put(key, properties.getProperty(key));
            }
            return String.format("Properties [%s]", this.dump(hm, dumpedObjects));
        }

        private String dumpImpl(Thread object, ArrayList dumpedObjects) {
            if (object == null) {
                return null;
            }
            return object.getClass().getName() + "[" + "@" + Integer.toHexString(object.hashCode()) + ", id=" + object.getId() + ", name=" + object.getName() + ", getPriority = " + object.getPriority() + ", getState = " + (Object)((Object)object.getState()) + ", isDaemon = " + object.isDaemon() + ", isAlive = " + object.isAlive() + ", isInterrupted = " + object.isInterrupted() + ", getThreadGroup = " + this.dump(object.getThreadGroup(), dumpedObjects) + "]" + object.getId();
        }

        private String dumpImpl(ThreadGroup object, ArrayList dumpedObjects) {
            return object.getClass().getName() + "[" + "@" + Integer.toHexString(object.hashCode()) + ", name=" + object.getName() + ", maxPriority=" + object.getMaxPriority() + ", isDaemon = " + object.isDaemon() + "]";
        }
    }

    private static class AndroidDumpExtension
    extends DumpExtension {
        private AndroidDumpExtension() {
        }

        @Override
        public String dumpImpl(Object value, ArrayList dumpedObjects) {
            if (!this.canDump(value)) {
                throw new IllegalArgumentException(value.getClass().getName() + " unsupported for dump");
            }
            if (value instanceof Uri) {
                return this.dumpImpl((Uri)value, dumpedObjects);
            }
            if (value instanceof URI) {
                return this.dumpImpl((URI)value, dumpedObjects);
            }
            if (value instanceof Activity) {
                return this.dumpImpl((Activity)value, dumpedObjects);
            }
            if (value instanceof Intent) {
                return this.dumpImpl((Intent)value, dumpedObjects);
            }
            if (value instanceof IntentFilter) {
                return this.dumpImpl((IntentFilter)value, dumpedObjects);
            }
            if (value instanceof Bundle) {
                return this.dumpImpl((Bundle)value, dumpedObjects);
            }
            if (value instanceof Pair) {
                return this.dumpImpl((Pair)value, dumpedObjects);
            }
            if (value instanceof ActivityManager.RunningTaskInfo) {
                return this.dumpImpl((ActivityManager.RunningTaskInfo)value, dumpedObjects);
            }
            if (value instanceof Cursor) {
                return this.dumpImpl((Cursor)value, dumpedObjects);
            }
            if (value instanceof SQLiteDatabase) {
                return this.dumpImpl((SQLiteDatabase)value, dumpedObjects);
            }
            if (value instanceof PermissionInfo) {
                return this.dumpImpl((PermissionInfo)value, dumpedObjects);
            }
            if (value instanceof PermissionGroupInfo) {
                return this.dumpImpl((PermissionGroupInfo)value, dumpedObjects);
            }
            if (value instanceof InstrumentationInfo) {
                return this.dumpImpl((InstrumentationInfo)value, dumpedObjects);
            }
            if (value instanceof ActivityInfo) {
                return this.dumpImpl((ActivityInfo)value, dumpedObjects);
            }
            if (value instanceof ServiceInfo) {
                return this.dumpImpl((ServiceInfo)value, dumpedObjects);
            }
            if (value instanceof ProviderInfo) {
                return this.dumpImpl((ProviderInfo)value, dumpedObjects);
            }
            if (value instanceof ComponentInfo) {
                return this.dumpImpl((ComponentInfo)value, dumpedObjects);
            }
            if (value instanceof ApplicationInfo) {
                return this.dumpImpl((ApplicationInfo)value, dumpedObjects);
            }
            if (value instanceof PackageInfo) {
                return this.dumpImpl((PackageInfo)value, dumpedObjects);
            }
            if (value instanceof FeatureInfo) {
                return this.dumpImpl((FeatureInfo)value, dumpedObjects);
            }
            if (value instanceof ResolveInfo) {
                return this.dumpImpl((ResolveInfo)value, dumpedObjects);
            }
            if (value instanceof ComponentName) {
                return this.dumpImpl((ComponentName)value, dumpedObjects);
            }
            if (value instanceof PackageItemInfo) {
                return this.dumpImpl((PackageItemInfo)value, dumpedObjects);
            }
            if (value instanceof ActivityManager.MemoryInfo) {
                return this.dumpImpl((ActivityManager.MemoryInfo)value, dumpedObjects);
            }
            if (value instanceof ActivityManager.RunningAppProcessInfo) {
                return this.dumpImpl((ActivityManager.RunningAppProcessInfo)value, dumpedObjects);
            }
            if (value instanceof Debug.MemoryInfo) {
                return this.dumpImpl((Debug.MemoryInfo)value, dumpedObjects);
            }
            if (value instanceof JSONObject) {
                return this.dumpImpl((JSONObject)value, dumpedObjects);
            }
            if (value instanceof JSONArray) {
                return this.dumpImpl((JSONArray)value, dumpedObjects);
            }
            if (value instanceof Bitmap) {
                return this.dumpImpl((Bitmap)value, dumpedObjects);
            }
            if (value instanceof Menu) {
                return this.dumpImpl((Menu)value, dumpedObjects);
            }
            if (value instanceof Typeface) {
                return this.dumpImpl((Typeface)value, dumpedObjects);
            }
            if (value instanceof View) {
                return this.dumpImpl((View)value, dumpedObjects);
            }
            throw new IllegalStateException("Failed dump " + value.getClass().getName());
        }

        @Override
        public boolean canDump(Object value) {
            if (value instanceof Uri) {
                return true;
            }
            if (value instanceof URI) {
                return true;
            }
            if (value instanceof Activity) {
                return true;
            }
            if (value instanceof Intent) {
                return true;
            }
            if (value instanceof IntentFilter) {
                return true;
            }
            if (value instanceof Bundle) {
                return true;
            }
            if (value instanceof Pair) {
                return true;
            }
            if (value instanceof ActivityManager.RunningTaskInfo) {
                return true;
            }
            if (value instanceof Cursor) {
                return true;
            }
            if (value instanceof SQLiteDatabase) {
                return true;
            }
            if (value instanceof PermissionInfo) {
                return true;
            }
            if (value instanceof PermissionGroupInfo) {
                return true;
            }
            if (value instanceof InstrumentationInfo) {
                return true;
            }
            if (value instanceof ActivityInfo) {
                return true;
            }
            if (value instanceof ServiceInfo) {
                return true;
            }
            if (value instanceof ProviderInfo) {
                return true;
            }
            if (value instanceof ComponentInfo) {
                return true;
            }
            if (value instanceof ApplicationInfo) {
                return true;
            }
            if (value instanceof PackageInfo) {
                return true;
            }
            if (value instanceof FeatureInfo) {
                return true;
            }
            if (value instanceof ResolveInfo) {
                return true;
            }
            if (value instanceof ComponentName) {
                return true;
            }
            if (value instanceof PackageItemInfo) {
                return true;
            }
            if (value instanceof ActivityManager.MemoryInfo) {
                return true;
            }
            if (value instanceof ActivityManager.RunningAppProcessInfo) {
                return true;
            }
            if (value instanceof Debug.MemoryInfo) {
                return true;
            }
            if (value instanceof JSONObject) {
                return true;
            }
            if (value instanceof JSONArray) {
                return true;
            }
            if (value instanceof Bitmap) {
                return true;
            }
            if (value instanceof Menu) {
                return true;
            }
            if (value instanceof Typeface) {
                return true;
            }
            return value instanceof View;
        }

        @SuppressLint(value={"NewApi"})
        private String dumpImpl(Uri uri, ArrayList dumpedObjects) {
            String authority = uri.getAuthority();
            String fragment = uri.getFragment();
            String host = uri.getHost();
            String path = uri.getPath();
            int port = uri.getPort();
            String query = uri.getQuery();
            String encodedAuthority = uri.getEncodedAuthority();
            String encodedFragment = uri.getEncodedFragment();
            String encodedPath = uri.getEncodedPath();
            String encodedQuery = uri.getEncodedQuery();
            String encodedSchemeSpecificPart = uri.getEncodedSchemeSpecificPart();
            String encodedUserInfo = uri.getEncodedUserInfo();
            String scheme = uri.getScheme();
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            String userInfo = uri.getUserInfo();
            String normalizeScheme = null;
            String lastPathSegment = uri.getLastPathSegment();
            List pathSegments = uri.getPathSegments();
            boolean isAbsolute = uri.isAbsolute();
            boolean isOpaque = uri.isOpaque();
            Boolean isHierarchical = uri.isHierarchical();
            Boolean isRelative = uri.isRelative();
            Set queryParameterNames = null;
            String toASCIIString = null;
            String normalize = null;
            if (OsVersionHelper.have(11)) {
                queryParameterNames = uri.getQueryParameterNames();
            }
            if (OsVersionHelper.have(16)) {
                normalizeScheme = uri.normalizeScheme().toString();
            }
            try {
                URI javaUri = URI.create(uri.toString());
                toASCIIString = javaUri.toASCIIString();
                normalize = javaUri.normalize().toString();
            }
            catch (Exception e) {
                Tracer.e(e);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(uri);
            sb.append("\n");
            sb.append(" authority = ").append(authority);
            sb.append("\n");
            sb.append(" encodedAuthority = ").append(encodedAuthority);
            sb.append("\n");
            sb.append(" encodedFragment = ").append(encodedFragment);
            sb.append("\n");
            sb.append(" encodedPath = ").append(encodedPath);
            sb.append("\n");
            sb.append(" encodedQuery = ").append(encodedQuery);
            sb.append("\n");
            sb.append(" encodedSchemeSpecificPart = ").append(encodedSchemeSpecificPart);
            sb.append("\n");
            sb.append(" encodedUserInfo = ").append(encodedUserInfo);
            sb.append("\n");
            sb.append(" fragment = ").append(fragment);
            sb.append("\n");
            sb.append(" host = ").append(host);
            sb.append("\n");
            sb.append(" lastPathSegment = ").append(lastPathSegment);
            sb.append("\n");
            sb.append(" path = ").append(path);
            sb.append("\n");
            sb.append(" pathSegments = ").append(pathSegments);
            sb.append("\n");
            sb.append(" port = ").append(port);
            sb.append("\n");
            sb.append(" query = ").append(query);
            sb.append("\n");
            sb.append(" queryParameterNames = ").append(queryParameterNames);
            sb.append("\n");
            sb.append(" scheme = ").append(scheme);
            sb.append("\n");
            sb.append(" schemeSpecificPart = ").append(schemeSpecificPart);
            sb.append("\n");
            sb.append(" userInfo = ").append(userInfo);
            sb.append("\n");
            sb.append(" toASCIIString = ").append(toASCIIString);
            sb.append("\n");
            sb.append(" normalize = ").append(normalize);
            sb.append("\n");
            sb.append(" normalizeScheme = ").append(normalizeScheme);
            sb.append("\n");
            sb.append(" isAbsolute = ").append(isAbsolute);
            sb.append("\n");
            sb.append(" isOpaque = ").append(isOpaque);
            sb.append("\n");
            sb.append(" isHierarchical = ").append(isHierarchical);
            sb.append("\n");
            sb.append(" isRelative = ").append(isRelative);
            sb.append("\n");
            return sb.toString();
        }

        @SuppressLint(value={"NewApi"})
        private String dumpImpl(URI uri, ArrayList dumpedObjects) {
            String authority = uri.getAuthority();
            String fragment = uri.getFragment();
            String host = uri.getHost();
            String path = uri.getPath();
            int port = uri.getPort();
            String query = uri.getQuery();
            String encodedAuthority = uri.getRawAuthority();
            String encodedFragment = uri.getRawFragment();
            String encodedPath = uri.getRawPath();
            String encodedQuery = uri.getRawQuery();
            String encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
            String encodedUserInfo = uri.getRawUserInfo();
            String scheme = uri.getScheme();
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            String userInfo = uri.getUserInfo();
            String toASCIIString = uri.toASCIIString();
            String normalize = uri.normalize().toString();
            String normalizeScheme = null;
            String lastPathSegment = null;
            List pathSegments = null;
            boolean isAbsolute = uri.isAbsolute();
            boolean isOpaque = uri.isOpaque();
            Boolean isHierarchical = null;
            Boolean isRelative = null;
            Set queryParameterNames = null;
            try {
                Uri androidUri = Uri.parse((String)uri.toString());
                lastPathSegment = androidUri.getLastPathSegment();
                pathSegments = androidUri.getPathSegments();
                isHierarchical = androidUri.isHierarchical();
                isRelative = androidUri.isRelative();
                if (OsVersionHelper.have(11)) {
                    queryParameterNames = androidUri.getQueryParameterNames();
                }
                if (OsVersionHelper.have(16)) {
                    normalizeScheme = androidUri.normalizeScheme().toString();
                }
            }
            catch (Exception e) {
                Tracer.e(e);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(uri);
            sb.append("\n");
            sb.append(" authority = ").append(authority);
            sb.append("\n");
            sb.append(" encodedAuthority = ").append(encodedAuthority);
            sb.append("\n");
            sb.append(" encodedFragment = ").append(encodedFragment);
            sb.append("\n");
            sb.append(" encodedPath = ").append(encodedPath);
            sb.append("\n");
            sb.append(" encodedQuery = ").append(encodedQuery);
            sb.append("\n");
            sb.append(" encodedSchemeSpecificPart = ").append(encodedSchemeSpecificPart);
            sb.append("\n");
            sb.append(" encodedUserInfo = ").append(encodedUserInfo);
            sb.append("\n");
            sb.append(" fragment = ").append(fragment);
            sb.append("\n");
            sb.append(" host = ").append(host);
            sb.append("\n");
            sb.append(" lastPathSegment = ").append(lastPathSegment);
            sb.append("\n");
            sb.append(" path = ").append(path);
            sb.append("\n");
            sb.append(" pathSegments = ").append(pathSegments);
            sb.append("\n");
            sb.append(" port = ").append(port);
            sb.append("\n");
            sb.append(" query = ").append(query);
            sb.append("\n");
            sb.append(" queryParameterNames = ").append(queryParameterNames);
            sb.append("\n");
            sb.append(" scheme = ").append(scheme);
            sb.append("\n");
            sb.append(" schemeSpecificPart = ").append(schemeSpecificPart);
            sb.append("\n");
            sb.append(" userInfo = ").append(userInfo);
            sb.append("\n");
            sb.append(" toASCIIString = ").append(toASCIIString);
            sb.append("\n");
            sb.append(" normalize = ").append(normalize);
            sb.append("\n");
            sb.append(" normalizeScheme = ").append(normalizeScheme);
            sb.append("\n");
            sb.append(" isAbsolute = ").append(isAbsolute);
            sb.append("\n");
            sb.append(" isOpaque = ").append(isOpaque);
            sb.append("\n");
            sb.append(" isHierarchical = ").append(isHierarchical);
            sb.append("\n");
            sb.append(" isRelative = ").append(isRelative);
            sb.append("\n");
            return sb.toString();
        }

        private String dumpImpl(Activity activity, ArrayList dumpedObjects) {
            return activity.getClass().getSimpleName();
        }

        @SuppressLint(value={"NewApi"})
        private String dumpImpl(Intent intent, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder("Intent [");
            sb.append("act=").append(intent.getAction());
            sb.append(", cat=").append(this.dump(intent.getCategories(), dumpedObjects));
            sb.append(", dat=").append(this.dump(intent.getData(), dumpedObjects));
            sb.append(", typ=").append(intent.getType());
            sb.append(", flg=0x").append(Integer.toHexString(intent.getFlags()));
            sb.append(", pkg=").append(intent.getPackage());
            sb.append(", cmp=").append(intent.getComponent() != null ? intent.getComponent().flattenToShortString() : null);
            sb.append(", bnds=").append(intent.getSourceBounds());
            if (OsVersionHelper.have(16)) {
                sb.append(", clip=").append(this.dump(intent.getClipData(), dumpedObjects));
            }
            sb.append(", ext=").append(this.dump(intent.getExtras(), dumpedObjects));
            if (OsVersionHelper.have(15)) {
                sb.append(", sel=").append(this.dump(intent.getSelector(), dumpedObjects));
            }
            sb.append("]");
            return sb.toString();
        }

        private String dumpImpl(IntentFilter intentFilter, ArrayList dumpedObjects) {
            return "IntentFilter [Actions : " + this.dump(intentFilter.actionsIterator(), dumpedObjects) + "]";
        }

        private String dumpImpl(Bundle bundle, ArrayList dumpedObjects) {
            return "Bundle [Content : " + this.dump(DumpUtils.ConvertCollections.toHashMap(bundle), dumpedObjects) + "]";
        }

        private String dumpImpl(Pair pair, ArrayList dumpedObjects) {
            return String.format("Pair[first = %s, second = %s]", this.dump(pair.first, dumpedObjects), this.dump(pair.second, dumpedObjects));
        }

        private String dumpImpl(ActivityManager.RunningTaskInfo info, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append("RunningTaskInfo [");
            sb.append("topActivity = ");
            if (info.topActivity != null) {
                sb.append(info.topActivity.getPackageName()).append(" / ").append(info.topActivity.getClassName());
            } else {
                sb.append("null");
            }
            sb.append(", description = ");
            if (info.topActivity != null) {
                sb.append(info.description);
            } else {
                sb.append("null");
            }
            sb.append("]");
            return sb.toString();
        }

        private String dumpImpl(Cursor cursor, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append(">>>>> Dumping cursor " + cursor + "\n");
            if (cursor != null) {
                int startPos = cursor.getPosition();
                cursor.moveToPosition(-1);
                while (cursor.moveToNext()) {
                    String[] cols = cursor.getColumnNames();
                    sb.append("" + cursor.getPosition() + " {\n");
                    int length = cols.length;
                    for (int i = 0; i < length; ++i) {
                        String value;
                        try {
                            value = cursor.getString(i);
                        }
                        catch (SQLiteException e) {
                            value = "<unprintable>";
                        }
                        if (cols[i] != null && cols[i].contains("date")) {
                            try {
                                String date = DateTimeHelper.getDate(Long.parseLong(value));
                                sb.append("   " + cols[i] + '=' + value + "(" + date + ")" + "\n");
                            }
                            catch (Throwable e) {
                                sb.append("   " + cols[i] + '=' + value + "\n");
                            }
                            continue;
                        }
                        sb.append("   " + cols[i] + '=' + value + "\n");
                    }
                    sb.append("}\n");
                }
                cursor.moveToPosition(startPos);
            }
            sb.append("<<<<<\n");
            return sb.toString();
        }

        @SuppressLint(value={"NewApi"})
        private String dumpImpl(SQLiteDatabase database, ArrayList dumpedObjects) {
            return DumpUtils.Database.dump(database);
        }

        private String dumpImpl(PermissionInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(PermissionGroupInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(InstrumentationInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ActivityInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ServiceInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ProviderInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ComponentInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ApplicationInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(PackageInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(FeatureInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ResolveInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ComponentName info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(PackageItemInfo info, ArrayList dumpedObjects) {
            return DumpUtils.dumpFields(info);
        }

        private String dumpImpl(ActivityManager.MemoryInfo info, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder("MemoryInfo{");
            sb.append("\navailMem=").append(TextHelper.humanReadableByteCount(info.availMem));
            if (OsVersionHelper.have(16)) {
                sb.append(",\ntotalMem=").append(TextHelper.humanReadableByteCount(info.totalMem));
            }
            sb.append(",\nthreshold=").append(TextHelper.humanReadableByteCount(info.threshold));
            sb.append(",\nlowMemory=").append(info.lowMemory);
            sb.append('}');
            return sb.toString();
        }

        private String dumpImpl(ActivityManager.RunningAppProcessInfo info, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder("RunningAppProcessInfo{");
            sb.append("\nprocessName='").append(info.processName).append('\'');
            sb.append(",\npid=").append(info.pid);
            sb.append(",\nuid=").append(info.uid);
            sb.append(",\npkgList=").append(Arrays.toString(info.pkgList));
            sb.append(",\nlastTrimLevel=").append(DumpUtils.dumpTrimMemory(info.lastTrimLevel));
            sb.append(",\nimportance=").append(info.importance);
            sb.append(",\nlru=").append(info.lru);
            sb.append(",\nimportanceReasonCode=").append(info.importanceReasonCode);
            sb.append(",\nimportanceReasonPid=").append(info.importanceReasonPid);
            sb.append(",\nimportanceReasonComponent=").append(Dumper.dump((Object)info.importanceReasonComponent, dumpedObjects));
            sb.append('}');
            return sb.toString();
        }

        private String dumpImpl(Debug.MemoryInfo info, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder("MemoryInfo{");
            sb.append("\ndalvikPss=").append(TextHelper.humanReadableByteCount(info.dalvikPss));
            sb.append(",\ndalvikPrivateDirty=").append(TextHelper.humanReadableByteCount(info.dalvikPrivateDirty));
            sb.append(",\ndalvikSharedDirty=").append(TextHelper.humanReadableByteCount(info.dalvikSharedDirty));
            sb.append(",\nnativePss=").append(TextHelper.humanReadableByteCount(info.nativePss));
            sb.append(",\nnativePrivateDirty=").append(TextHelper.humanReadableByteCount(info.nativePrivateDirty));
            sb.append(",\nnativeSharedDirty=").append(TextHelper.humanReadableByteCount(info.nativeSharedDirty));
            sb.append(",\notherPss=").append(TextHelper.humanReadableByteCount(info.otherPss));
            sb.append(",\notherSharedDirty=").append(TextHelper.humanReadableByteCount(info.otherSharedDirty));
            if (OsVersionHelper.have(19)) {
                sb.append(",\ngetTotalPrivateClean=").append(TextHelper.humanReadableByteCount(info.getTotalPrivateClean()));
            }
            sb.append(",\ngetTotalPrivateDirty=").append(TextHelper.humanReadableByteCount(info.getTotalPrivateDirty()));
            sb.append(",\ngetTotalPss=").append(TextHelper.humanReadableByteCount(info.getTotalPss()));
            if (OsVersionHelper.have(19)) {
                sb.append(",\ngetTotalSharedClean=").append(TextHelper.humanReadableByteCount(info.getTotalSharedClean()));
            }
            sb.append(",\ngetTotalSharedDirty=").append(TextHelper.humanReadableByteCount(info.getTotalSharedDirty()));
            if (OsVersionHelper.have(19)) {
                sb.append(",\ngetTotalSwappablePss=").append(TextHelper.humanReadableByteCount(info.getTotalSwappablePss()));
            }
            sb.append('}');
            return sb.toString();
        }

        private String dumpImpl(JSONObject object, ArrayList dumpedObjects) {
            return object.toString();
        }

        private String dumpImpl(JSONArray array, ArrayList dumpedObjects) {
            return array.toString();
        }

        private String dumpImpl(Bitmap bitmap, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bitmap {\n").append(bitmap.getWidth()).append(";").append(bitmap.getHeight()).append(", \nmin size = ").append(TextHelper.humanReadableByteCount(bitmap.getByteCount()));
            if (OsVersionHelper.have(19)) {
                sb.append(", \nsize = ").append(TextHelper.humanReadableByteCount(bitmap.getAllocationByteCount()));
            }
            sb.append(", \ndensity = ").append(bitmap.getDensity());
            sb.append(", \nisRecycled = ").append(bitmap.isRecycled());
            sb.append(", \nisMutable = ").append(bitmap.isMutable());
            if (OsVersionHelper.have(17)) {
                sb.append(", \nisPremultiplied = ").append(bitmap.isPremultiplied());
            }
            sb.append(", \nhasAlpha = ").append(bitmap.hasAlpha());
            if (OsVersionHelper.have(17)) {
                sb.append(", \nhasMipMap = ").append(bitmap.hasMipMap());
            }
            sb.append(", \ngenerationId = ").append(bitmap.getGenerationId());
            sb.append("}");
            return sb.toString();
        }

        private String dumpImpl(Menu menu, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append("Menu {\n");
            sb.append("item count = ").append(menu.size()).append("\n");
            for (int i = 0; i < menu.size(); ++i) {
                MenuItem item = menu.getItem(i);
                sb.append("item").append(i).append("{id=").append(item.getItemId()).append(" visible = ").append(item.isVisible()).append(" title = ").append(item.getTitle()).append("}\n");
            }
            sb.append("}");
            return sb.toString();
        }

        private String dumpImpl(Typeface typeface, ArrayList dumpedObjects) {
            StringBuilder sb = new StringBuilder();
            sb.append("Typeface {\n");
            sb.append("isBold = ").append(typeface.isBold()).append("\n");
            sb.append("isItalic = ").append(typeface.isItalic()).append("\n");
            sb.append("}");
            return sb.toString();
        }

        private String dumpImpl(View object, ArrayList dumpedObjects) {
            return DumpUtils.dumpViewState(object);
        }
    }

    public static abstract class DumpExtension {
        protected final String dump(Object value, ArrayList dumpedObjects) {
            return Dumper.dump(value, dumpedObjects);
        }

        public abstract String dumpImpl(Object var1, ArrayList var2);

        public abstract boolean canDump(Object var1);
    }
}

