/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.utils.log;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import xyz.truenight.utils.log.Dumper;
import xyz.truenight.utils.log.Tracer;

public class Log {
    private static final AtomicReference<LogImplementation> logImpl = new AtomicReference<AndroidLog>(new AndroidLog());

    private Log() {
    }

    public static LogImplementation get() {
        return logImpl.get();
    }

    public static void set(LogImplementation logImpl) {
        Log.logImpl.set(logImpl);
    }

    public static void v(String tag, String msg) {
        Log.get().v(tag, msg);
    }

    public static void v(String tag, Throwable tr) {
        Log.get().v(tag, tr);
    }

    public static void v(String tag, String msg, Throwable tr) {
        Log.get().v(tag, msg, tr);
    }

    public static void d(String tag, String msg) {
        Log.get().d(tag, msg);
    }

    public static void d(String tag, Throwable tr) {
        Log.get().d(tag, tr);
    }

    public static void d(String tag, String msg, Throwable tr) {
        Log.get().d(tag, msg, tr);
    }

    public static void i(String tag, String msg) {
        Log.get().i(tag, msg);
    }

    public static void i(String tag, Throwable tr) {
        Log.get().i(tag, tr);
    }

    public static void i(String tag, String msg, Throwable tr) {
        Log.get().i(tag, msg, tr);
    }

    public static void w(String tag, String msg) {
        Log.get().w(tag, msg);
    }

    public static void w(String tag, Throwable tr) {
        Log.get().w(tag, tr);
    }

    public static void w(String tag, String msg, Throwable tr) {
        Log.get().w(tag, msg, tr);
    }

    public static void e(String tag, String msg) {
        Log.get().e(tag, msg);
    }

    public static void e(String tag, Throwable th) {
        Log.get().e(tag, th);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Log.get().e(tag, msg, tr);
    }

    public static void setEnable(boolean enabled) {
        Log.get().setEnable(enabled);
    }

    public static class LogSaveHelper {
        public static final int ONE_K = 1024;
        public static final int TEN_K = 10240;
        public static final long ONE_MB = 0x100000L;
        public static final long TEN_MB = 0xA00000L;
        private volatile long maxLogFileSize = 0xA00000L;
        private volatile File logFileDir;
        private volatile String logFileName;
        private volatile String oldLogFileName;
        private volatile File logFile;
        private volatile FileOutputStream logFileStream;

        public void setSettings(File logFileDir, String logFileName, String oldLogFileName, long maxFileSize) {
            this.maxLogFileSize = maxFileSize;
            this.logFileName = logFileName;
            this.oldLogFileName = oldLogFileName;
            this.logFileDir = logFileDir;
        }

        public boolean write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            FileOutputStream logFileStream = this.getLogFileStream(false);
            if (logFileStream != null) {
                logFileStream.write(buffer, byteOffset, byteCount);
                logFileStream.flush();
            }
            return true;
        }

        public void write(String s) throws IOException {
            byte[] bytes = s.getBytes(Charset.forName("UTF-8"));
            this.write(bytes, 0, bytes.length);
        }

        public FileOutputStream getLogFileStream(boolean prepare) {
            if (prepare || this.logFile != null && this.logFile.length() > this.maxLogFileSize) {
                this.closeLogFileStream();
                this.prepareLogFile();
                this.initLogWriter();
            }
            if (this.logFileStream == null || this.logFile == null) {
                this.initLogWriter();
            }
            return this.logFileStream;
        }

        public void closeLogFileStream() {
            if (this.logFileStream != null) {
                try {
                    this.logFileStream.close();
                    this.logFileStream = null;
                    this.logFile = null;
                }
                catch (IOException e) {
                    this.logFileStream = null;
                    this.logFile = null;
                    Tracer.e("error closing output stream");
                }
            }
        }

        private File prepareLogFile() {
            File f = null;
            try {
                f = new File(this.logFileDir, this.logFileName);
                if (f.exists()) {
                    File from = new File(this.logFileDir, this.logFileName);
                    File to = new File(this.logFileDir, this.oldLogFileName);
                    if (to.exists()) {
                        to.delete();
                    }
                    from.renameTo(to);
                }
                f = new File(this.logFileDir, this.logFileName);
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return f;
        }

        private File getLogFile() {
            File f = null;
            try {
                f = new File(this.logFileDir, this.logFileName);
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return f;
        }

        private void initLogWriter() {
            try {
                this.logFile = this.getLogFile();
                this.logFileStream = new FileOutputStream(this.logFile, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class LogSet
    extends LogImplementation {
        private final LogImplementation[] logImplArr;

        public LogSet(LogImplementation ... logImplArr) {
            this.logImplArr = logImplArr;
        }

        @Override
        public void log(LogLevel level, String tag, String s) {
            if (this.isEnabled()) {
                for (LogImplementation log : this.logImplArr) {
                    log.log(level, tag, s);
                }
            }
        }

        public static LogImplementation getFullLogSet(Context context) {
            return LogSet.getFullLogSet(context, 10L);
        }

        public static LogImplementation getFullLogSet(Context context, long mbSize) {
            return new LogSet(new FileLog(context.getCacheDir(), mbSize), new FileLog(Environment.getExternalStorageDirectory(), mbSize), new AndroidLog());
        }
    }

    public static class FileLog
    extends LogImplementation {
        private LogSaveHelper mLogSaveHelper = new LogSaveHelper();
        private ThreadLocal<SimpleDateFormat> df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
            }
        };

        public FileLog(File dir) {
            this(dir, 10L);
        }

        public FileLog(File dir, long mbSize) {
            this(dir, mbSize, "log.txt", "old_log.txt");
        }

        public FileLog(File dir, long mbSize, String logFileName, String oldLogFileName) {
            this.mLogSaveHelper.setSettings(dir, logFileName, oldLogFileName, 0x100000L * mbSize);
        }

        public void resetFile() {
            this.mLogSaveHelper.getLogFileStream(true);
        }

        @Override
        public void log(LogLevel level, String tag, String s) {
            if (this.isEnabled()) {
                String time = this.df.get().format(new Date(System.currentTimeMillis()));
                long tid = Thread.currentThread().getId();
                this.write(String.format(Locale.US, "%s    %d/ %s %s, %s\n", time, tid, "" + (Object)((Object)level), tag, s));
            }
        }

        private void write(String s) {
            try {
                this.mLogSaveHelper.write(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class AndroidLog
    extends LogImplementation {
        private static final int LOG_CHUNK_SIZE = 4000;

        @Override
        public void log(LogLevel level, String tag, String msg) {
            if (this.isEnabled()) {
                int msgLines = msg.length() / 4000 + (msg.length() % 4000 == 0 ? 0 : 1);
                if (msgLines > 1) {
                    this.logInternal(level, tag, "=====start=====(size = " + msg.length() + " lines = " + msgLines + ")\n");
                }
                int len = msg.length();
                for (int i = 0; i < len; i += 4000) {
                    int end = Math.min(len, i + 4000);
                    this.logInternal(level, tag, msg.substring(i, end));
                }
                if (msgLines > 1) {
                    this.logInternal(level, tag, "=====end=====");
                }
            }
        }

        private void logInternal(LogLevel level, String tag, String msg) {
            switch (level) {
                case V: {
                    android.util.Log.v((String)tag, (String)msg);
                    break;
                }
                case D: {
                    android.util.Log.d((String)tag, (String)msg);
                    break;
                }
                case I: {
                    android.util.Log.i((String)tag, (String)msg);
                    break;
                }
                case W: {
                    android.util.Log.w((String)tag, (String)msg);
                    break;
                }
                case E: {
                    android.util.Log.e((String)tag, (String)msg);
                }
            }
        }
    }

    public static abstract class LogImplementation {
        private AtomicBoolean mEnabled = new AtomicBoolean(true);

        public void setEnable(boolean enabled) {
            this.mEnabled.set(enabled);
        }

        public boolean isEnabled() {
            return this.mEnabled.get();
        }

        public void v(String tag, String msg) {
            this.log(LogLevel.V, tag, msg);
        }

        public void v(String tag, Throwable tr) {
            this.log(LogLevel.V, tag, Dumper.dump((Object)tr));
        }

        public void v(String tag, String msg, Throwable tr) {
            this.log(LogLevel.V, tag, msg + '\n' + Dumper.dump((Object)tr));
        }

        public void d(String tag, String msg) {
            this.log(LogLevel.D, tag, msg);
        }

        public void d(String tag, Throwable tr) {
            this.log(LogLevel.D, tag, Dumper.dump((Object)tr));
        }

        public void d(String tag, String msg, Throwable tr) {
            this.log(LogLevel.D, tag, msg + '\n' + Dumper.dump((Object)tr));
        }

        public void i(String tag, String msg) {
            this.log(LogLevel.I, tag, msg);
        }

        public void i(String tag, Throwable tr) {
            this.log(LogLevel.I, tag, Dumper.dump((Object)tr));
        }

        public void i(String tag, String msg, Throwable tr) {
            this.log(LogLevel.I, tag, msg + '\n' + Dumper.dump((Object)tr));
        }

        public void w(String tag, String msg) {
            this.log(LogLevel.W, tag, msg);
        }

        public void w(String tag, Throwable tr) {
            this.log(LogLevel.W, tag, Dumper.dump((Object)tr));
        }

        public void w(String tag, String msg, Throwable tr) {
            this.log(LogLevel.W, tag, msg + '\n' + Dumper.dump((Object)tr));
        }

        public void e(String tag, String msg) {
            this.log(LogLevel.E, tag, msg);
        }

        public void e(String tag, Throwable tr) {
            this.log(LogLevel.E, tag, Dumper.dump((Object)tr));
        }

        public void e(String tag, String msg, Throwable tr) {
            this.log(LogLevel.E, tag, msg + '\n' + Dumper.dump((Object)tr));
        }

        public abstract void log(LogLevel var1, String var2, String var3);
    }

    public static enum LogLevel {
        V,
        D,
        I,
        W,
        E;

    }
}

