/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.utils.log;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import xyz.truenight.utils.ConcurrentMap;
import xyz.truenight.utils.log.Dumper;
import xyz.truenight.utils.log.Tracer;

public class Profiler {
    private static final AtomicInteger mCounter = new AtomicInteger(0);
    private static volatile long startTime;
    private static final Timing DEFAULT_TIMING;

    public static void setStartTime(long startTime) {
        Profiler.startTime = startTime;
    }

    public static long getTimeFromStart() {
        return SystemClock.elapsedRealtime() - startTime;
    }

    public static String getTimeFromStartStr() {
        return Dumper.DateTimeHelper.getSecondDuration(Profiler.getTimeFromStart());
    }

    public static Timing getNewInstance() {
        return new Timing();
    }

    public static void reset() {
        DEFAULT_TIMING.reset();
    }

    public static void start() {
        DEFAULT_TIMING.start();
    }

    public static void stop() {
        DEFAULT_TIMING.stop();
    }

    public static double averageTime() {
        return DEFAULT_TIMING.averageTime();
    }

    public static double averageTimeThread() {
        return DEFAULT_TIMING.averageTimeThread();
    }

    public static long getLaunches() {
        return DEFAULT_TIMING.getLaunches();
    }

    public static long getTotalDuration() {
        return DEFAULT_TIMING.getTotalDuration();
    }

    public static long getTotalDurationThread() {
        return DEFAULT_TIMING.getTotalDurationThread();
    }

    public static long getLastDuration() {
        return DEFAULT_TIMING.getLastDuration();
    }

    public static long getLastStart() {
        return DEFAULT_TIMING.getLastStart();
    }

    public static long getLastStop() {
        return DEFAULT_TIMING.getLastStop();
    }

    @NonNull
    public static Timing get(Object key) {
        return DEFAULT_TIMING.get(key);
    }

    @NonNull
    public ConcurrentMap getMetadata() {
        return DEFAULT_TIMING.getMetadata();
    }

    public static void printReport() {
        Tracer.config().depthOffset(1).print(Profiler.getReport());
    }

    public static String getReport() {
        return DEFAULT_TIMING.getReport();
    }

    public static String getShortReport() {
        return DEFAULT_TIMING.getShortReport();
    }

    public static String getFullReport() {
        return DEFAULT_TIMING.getFullReport();
    }

    public static String getFullReport(SortType sortType) {
        return DEFAULT_TIMING.getFullReport(sortType);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return mCounter;
    }

    static {
        DEFAULT_TIMING = Profiler.getNewInstance();
    }

    public static class Timing {
        private final int ordinalNumber = Profiler.access$000().incrementAndGet();
        private final ConcurrentMap<Object, Timing> timings = new ConcurrentMap();
        private final ConcurrentMap metadata = new ConcurrentMap();
        private volatile long launches;
        private volatile long lastStartThread;
        private volatile long lastStopThread;
        private volatile long totalDurationThread;
        private volatile long lastDurationThread;
        private volatile long lastStart;
        private volatile long lastStop;
        private volatile long totalDuration;
        private volatile long lastDuration;
        private volatile long firstStart;

        public void reset() {
            this.launches = 0L;
            this.lastStartThread = 0L;
            this.lastStopThread = 0L;
            this.totalDurationThread = 0L;
            this.lastDurationThread = 0L;
            this.lastStart = 0L;
            this.lastStop = 0L;
            this.totalDuration = 0L;
            this.lastDuration = 0L;
            this.timings.clear();
            this.metadata.clear();
        }

        public void start() {
            if (this.firstStart == 0L) {
                this.firstStart = SystemClock.elapsedRealtime() - startTime;
            }
            this.lastStart = SystemClock.elapsedRealtime();
            this.lastStartThread = SystemClock.currentThreadTimeMillis();
        }

        public void stop() {
            this.lastStop = SystemClock.elapsedRealtime();
            this.lastDuration = this.lastStop - this.lastStart;
            this.totalDuration += this.lastDuration;
            this.lastStopThread = SystemClock.currentThreadTimeMillis();
            this.lastDurationThread = this.lastStopThread - this.lastStartThread;
            this.totalDurationThread += this.lastDurationThread;
            ++this.launches;
        }

        public double averageTime() {
            return (double)this.totalDuration / (double)this.launches;
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }

        public long getLastDuration() {
            return this.lastDuration;
        }

        public long getLastStart() {
            return this.lastStart;
        }

        public long getLastStop() {
            return this.lastStop;
        }

        public double averageTimeThread() {
            return (double)this.totalDurationThread / (double)this.launches;
        }

        public long getTotalDurationThread() {
            return this.totalDurationThread;
        }

        public long getLastDurationThread() {
            return this.lastDurationThread;
        }

        public long getLastStartThread() {
            return this.lastStartThread;
        }

        public long getLastStopThread() {
            return this.lastStopThread;
        }

        public long getLaunches() {
            return this.launches;
        }

        @NonNull
        public Timing get(Object key) {
            Timing timing = (Timing)this.timings.get(key);
            if (timing == null) {
                timing = new Timing();
                this.timings.put(key, (Object)timing);
            }
            return timing;
        }

        @NonNull
        public ConcurrentMap getMetadata() {
            return this.metadata;
        }

        public void printReport() {
            Tracer.config().depthOffset(1).print(this.getReport());
        }

        public String getReport() {
            StringBuilder sb = new StringBuilder();
            sb.append(" averageTime = ").append(this.averageTime()).append(" threadAverageTime = ").append(this.averageTimeThread()).append(" launches = ").append(this.getLaunches()).append(" total duration = ").append(this.getTotalDuration()).append(" thread total duration = ").append(this.getTotalDurationThread()).append(" last duration = ").append(this.getLastDuration()).append(" thread last duration = ").append(this.getLastDurationThread()).append(" first start = ").append(Dumper.DateTimeHelper.getSecondDuration(this.firstStart));
            return sb.toString();
        }

        public String getShortReport() {
            StringBuilder sb = new StringBuilder();
            sb.append(" averageTime = ").append(this.averageTime()).append(" threadAverageTime = ").append(this.averageTimeThread()).append(" launches = ").append(this.getLaunches()).append(" total duration = ").append(this.getTotalDuration()).append(" thread total duration = ").append(this.getTotalDurationThread()).append(" first start = ").append(Dumper.DateTimeHelper.getSecondDuration(this.firstStart));
            return sb.toString();
        }

        public String getFullReport() {
            return this.getFullReport(SortType.KEY_NAME);
        }

        public String getFullReport(SortType sortType) {
            StringBuilder sb = new StringBuilder();
            ArrayList keys = new ArrayList();
            keys.add(null);
            keys.addAll(Dumper.ReflectionHelper.getField(this.timings, "MAP", ConcurrentHashMap.class).keySet());
            switch (sortType) {
                case ORDINAL_NUMBER: {
                    Collections.sort(keys, new Comparator<Object>(){

                        @Override
                        public int compare(Object lhsObj, Object rhsObj) {
                            int rhs;
                            int lhs = Timing.this.get(lhsObj).ordinalNumber;
                            return lhs < (rhs = Timing.this.get(rhsObj).ordinalNumber) ? -1 : (lhs == rhs ? 0 : 1);
                        }
                    });
                    break;
                }
                case KEY_NAME: {
                    Collections.sort(keys, new Comparator<Object>(){

                        @Override
                        public int compare(Object lhs, Object rhs) {
                            String lhsStr = lhs == null ? "default" : String.valueOf(lhs);
                            String rhsStr = rhs == null ? "default" : String.valueOf(rhs);
                            return lhsStr.compareTo(rhsStr);
                        }
                    });
                    break;
                }
                case AVERAGE_TIME: {
                    Collections.sort(keys, new Comparator<Object>(){

                        @Override
                        public int compare(Object lhsObj, Object rhsObj) {
                            double rhs;
                            double lhs = Timing.this.get(rhsObj).averageTime();
                            return lhs < (rhs = Timing.this.get(lhsObj).averageTime()) ? -1 : (lhs == rhs ? 0 : 1);
                        }
                    });
                }
            }
            for (Object key : keys) {
                String keyStr = key == null ? "default" : String.valueOf(key);
                Timing item = key == null ? this : this.get(key);
                sb.append(keyStr).append(": ").append(item.getReport()).append("\n");
            }
            sb.append("total").append(": ").append(this.getTotalTiming().getShortReport()).append("\n");
            return sb.toString();
        }

        public Timing getTotalTiming() {
            ArrayList keys = new ArrayList();
            keys.add(null);
            keys.addAll(Dumper.ReflectionHelper.getField(this.timings, "MAP", ConcurrentHashMap.class).keySet());
            Timing totalTiming = new Timing();
            for (Object key : keys) {
                Timing item = key == null ? this : this.get(key);
                totalTiming.launches += item.getLaunches();
                totalTiming.totalDuration += item.getTotalDuration();
                totalTiming.totalDurationThread += item.getLastDurationThread();
            }
            return totalTiming;
        }
    }

    public static enum SortType {
        ORDINAL_NUMBER,
        KEY_NAME,
        AVERAGE_TIME;

    }
}

