/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.utils.log;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import xyz.truenight.utils.ConcurrentMap;
import xyz.truenight.utils.log.Dumper;
import xyz.truenight.utils.log.Log;

public class Tracer {
    private static AtomicReference<Class<?>> dumpClass = new AtomicReference<Class<Dumper>>(Dumper.class);
    private static AtomicBoolean isPrintToLog = new AtomicBoolean(true);
    public static final String TRACER = "Tracer";
    private static final int CLIENT_CODE_STACK_INDEX;
    private static final ConcurrentMap S_CONCURRENT_MAP;
    private static final AtomicReference<Log.LogImplementation> logImpl;

    private Tracer() {
    }

    private static void setLog(Log.LogImplementation logImpl) {
        Tracer.logImpl.set(logImpl);
    }

    private static String getSteInfo(int depth, int depthOffset) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String result = null;
        if (depth == 1) {
            result = stackTrace[CLIENT_CODE_STACK_INDEX + depthOffset].toString();
        } else if (depth > 1) {
            int lastNeedfulIndex = CLIENT_CODE_STACK_INDEX + depthOffset + depth;
            int nextLine = 10;
            StringBuilder sb = new StringBuilder();
            for (int i = CLIENT_CODE_STACK_INDEX + depthOffset; i < stackTrace.length && i < lastNeedfulIndex; ++i) {
                sb.append(stackTrace[i]).append('\n');
            }
            result = sb.toString();
        }
        return result;
    }

    private static String getFileName(int depthOffset) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depthOffset];
        String result = element.getFileName();
        int position = result.indexOf(".java");
        return position > -1 ? result.substring(0, position) : result;
    }

    private static String getMethodName(int depthOffset) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depthOffset];
        return element.getMethodName();
    }

    public static void setEnable(boolean isPrintToLog) {
        Tracer.isPrintToLog.set(isPrintToLog);
    }

    public static void setDumper(Class<?> dumperClass) {
        dumpClass.set(dumperClass);
    }

    public static boolean isEnable() {
        return isPrintToLog.get();
    }

    public static void print() {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(Log.LogLevel.D, steInfo, false, null, null);
    }

    public static void print(Object ... msg) {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(Log.LogLevel.D, steInfo, false, dumpClass.get(), (Object)msg);
    }

    public static void print(Object msg) {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(Log.LogLevel.D, steInfo, false, null, msg);
    }

    public static void e(String msg) {
        Tracer.config().depthOffset(1).logLevel(Log.LogLevel.E).print(msg);
    }

    public static void e(Throwable tr) {
        Tracer.config().depthOffset(1).logLevel(Log.LogLevel.E).print('\n' + Dumper.dump((Object)tr));
    }

    public static void e(String msg, Throwable tr) {
        Tracer.config().depthOffset(1).logLevel(Log.LogLevel.E).print(msg + '\n' + Dumper.dump((Object)tr));
    }

    public static void w(String msg) {
        Tracer.config().depthOffset(1).logLevel(Log.LogLevel.W).print(msg);
    }

    public static void w(Throwable tr) {
        Tracer.config().depthOffset(1).logLevel(Log.LogLevel.W).print('\n' + Dumper.dump((Object)tr));
    }

    public static void w(String msg, Throwable tr) {
        Tracer.config().depthOffset(1).logLevel(Log.LogLevel.W).print(msg + '\n' + Dumper.dump((Object)tr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(Builder builder) {
        if (!isPrintToLog.get()) {
            return;
        }
        String steInfo = Tracer.getSteInfo(builder.depth, 2 + builder.depthOffset);
        if (builder.printCallerChanges) {
            String key = Tracer.firstLine(steInfo);
            ConcurrentMap concurrentMap = S_CONCURRENT_MAP;
            synchronized (concurrentMap) {
                if (S_CONCURRENT_MAP.compare((Object)key, (Object)steInfo)) {
                    return;
                }
                S_CONCURRENT_MAP.put((Object)key, (Object)steInfo);
            }
        }
        if (builder.wrap) {
            logImpl.get().log(builder.logLevel, TRACER, "===============start===============");
        }
        Tracer.print(builder.logLevel, steInfo, builder.threadInfo, builder.dump, builder.msg);
        if (builder.wrap) {
            logImpl.get().log(builder.logLevel, TRACER, "================end================");
        }
    }

    public static String firstLine(String string) {
        if (string == null) {
            return null;
        }
        int nextLineIndex = string.indexOf(10);
        if (nextLineIndex > 0) {
            return string.substring(0, nextLineIndex);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printChanges(Object key, Object msg) {
        if (!isPrintToLog.get()) {
            return;
        }
        if (key != null) {
            ConcurrentMap concurrentMap = S_CONCURRENT_MAP;
            synchronized (concurrentMap) {
                if (S_CONCURRENT_MAP.compare(key, msg)) {
                    return;
                }
                S_CONCURRENT_MAP.put(key, msg);
            }
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(Log.LogLevel.D, steInfo, false, null, msg);
    }

    private static void print(Log.LogLevel logLevel, String steInfo, boolean printThreadInfo, Class<?> dump, Object msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(steInfo);
        if (printThreadInfo) {
            Thread currentThread = Thread.currentThread();
            sb.append(" tid = ").append(currentThread.getId()).append(" tname = ");
            sb.append(currentThread.getName());
        }
        if (msg != null) {
            sb.append(" ").append(dump != null ? Tracer.dump(dump, msg) : msg.toString());
        }
        logImpl.get().log(logLevel, TRACER, sb.toString());
    }

    private static String dump(Class<?> dump, Object obj) {
        try {
            return (String)dump.getMethod("dump", Object.class).invoke(null, obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return "Dump error";
    }

    public static Builder config() {
        return new Builder();
    }

    static {
        S_CONCURRENT_MAP = new ConcurrentMap();
        logImpl = new AtomicReference<Log.LogImplementation>(Log.get());
        int i = 0;
        try {
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                ++i;
                if (!ste.getClassName().equals(Tracer.class.getName())) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLIENT_CODE_STACK_INDEX = ++i;
    }

    public static class Builder {
        private int depth = 1;
        private int depthOffset = 0;
        private boolean threadInfo;
        private boolean wrap;
        private Object msg;
        private Log.LogLevel logLevel = Log.LogLevel.D;
        private Class<?> dump = Dumper.class;
        private boolean printCallerChanges;

        public Builder threadInfo() {
            this.threadInfo = true;
            return this;
        }

        public Builder depth(int depth) {
            this.depth = depth;
            if (depth > 1) {
                this.wrap = true;
            }
            return this;
        }

        public Builder logLevel(Log.LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder depthOffset(int depthOffset) {
            this.depthOffset = depthOffset;
            return this;
        }

        public Builder threadInfo(boolean threadInfo) {
            this.threadInfo = threadInfo;
            return this;
        }

        public Builder dump(Class<?> dumperClass) {
            this.dump = dumperClass;
            return this;
        }

        public void print() {
            Tracer.print(this);
        }

        public void print(Object msg) {
            this.msg = msg;
            Tracer.print(this);
        }

        public void printCallerChanges() {
            this.printCallerChanges = true;
            Tracer.print(this);
        }

        public void printCallerChanges(Object msg) {
            this.printCallerChanges = true;
            this.msg = msg;
            Tracer.print(this);
        }
    }
}

