/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.auth;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.stereotype.Component;

@Component
public class SuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(SuccessHandler.class);
    @Value(value="${HOME_PAGE}")
    private String homePage;
    @Value(value="${app.server.host.homepage}")
    private String redirectUrl;
    private RequestCache requestCache = new HttpSessionRequestCache();

    public SuccessHandler() {
        this.setTargetUrlParameter("callback_url");
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String targetUrlParameter = this.getTargetUrlParameter();
        log.info("SuccessHandler isAlwaysUseDefaultTargetUrl: " + this.isAlwaysUseDefaultTargetUrl() + ",targetUrlParameter:" + targetUrlParameter + ",param:" + request.getParameter(targetUrlParameter));
        this.getRedirectStrategy().sendRedirect(request, response, this.redirectUrl);
    }
}

