/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.ohaotian.plugin.security.jwt.TokenState;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class Jwt {
    private static final Logger logger = LoggerFactory.getLogger(Jwt.class);
    private static byte[] SECRET;
    @Value(value="${app.secret}")
    private String secret;
    private static final JWSHeader header;

    @PostConstruct
    public void init() {
        Assert.notNull((Object)this.secret, (String)"secret is null");
        if (SECRET == null) {
            SECRET = this.secret.getBytes();
        }
    }

    public static void initSecret(String secret) {
        Assert.notNull((Object)secret, (String)"secret is null");
        SECRET = secret.getBytes();
    }

    public static String createToken(Map<String, Object> payload) {
        String tokenString = null;
        JWSObject jwsObject = new JWSObject(header, new Payload(new JSONObject(payload)));
        try {
            jwsObject.sign((JWSSigner)new MACSigner(SECRET));
            tokenString = jwsObject.serialize();
        }
        catch (JOSEException var4) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)var4);
        }
        return tokenString;
    }

    public static Map<String, Object> validToken(String token) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            Payload payload = jwsObject.getPayload();
            MACVerifier verifier = new MACVerifier(SECRET);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                JSONObject jsonOBj = payload.toJSONObject();
                resultMap.put("state", TokenState.VALID.toString());
                if (jsonOBj.containsKey((Object)"ext")) {
                    long extTime = Long.valueOf(jsonOBj.get((Object)"ext").toString());
                    long curTime = System.currentTimeMillis();
                    if (curTime > extTime) {
                        resultMap.clear();
                        resultMap.put("state", TokenState.EXPIRED.toString());
                    }
                }
                resultMap.put("data", jsonOBj);
            } else {
                resultMap.put("state", TokenState.INVALID.toString());
            }
        }
        catch (Exception var10) {
            resultMap.clear();
            resultMap.put("state", TokenState.INVALID.toString());
            logger.error("", (Throwable)var10);
        }
        return resultMap;
    }

    static {
        header = new JWSHeader(JWSAlgorithm.HS256, JOSEObjectType.JWT, (String)null, (Set)null, (URI)null, (JWK)null, (URI)null, (Base64URL)null, (Base64URL)null, (List)null, (String)null, (Map)null, (Base64URL)null);
    }
}

