/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.service;

import com.ohaotian.plugin.security.property.FilterStaticConfig;
import com.ohaotian.plugin.security.utils.RegexUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;

@Component
public class CasInvocationSecurityMetadataSourceService
implements FilterInvocationSecurityMetadataSource {
    private static final Logger log = LoggerFactory.getLogger(CasInvocationSecurityMetadataSourceService.class);
    @Autowired
    private FilterStaticConfig filterStaticConfig;

    public Collection<ConfigAttribute> loadResourceDefine(String url) {
        ArrayList<ConfigAttribute> array = new ArrayList<ConfigAttribute>();
        array.add((ConfigAttribute)new SecurityConfig(url));
        return array;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String url = request.getRequestURI();
        url = url.replaceFirst(request.getContextPath(), "");
        log.info(url);
        boolean b = this.wildcardEquals(url);
        return b ? null : this.loadResourceDefine(url);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }

    private boolean wildcardEquals(String reqPath) {
        String url;
        String regex;
        String regPath;
        Iterator<String> var2 = this.filterStaticConfig.getResources().iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!Pattern.compile(regPath = RegexUtils.getRegPath(regex = (url = var2.next()).replace("**", "*").replace("*", ".*"))).matcher(reqPath).matches());
        return true;
    }
}

