/*
 * Decompiled with CFR 0.152.
 */
package com.ccit.sm.utils;

import com.ccit.sm.dto.PlainObj;
import com.ccit.sm.sm3.SM3;
import com.ccit.sm.sm4.SM4;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.regex.Pattern;

public class DBUtils {
    private static final String SPLIT = "_,,_";
    private static final String MESSAGE = "\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f";

    public static String encrypt(Object obj) throws JsonProcessingException {
        return DBUtils.encrypt(obj, "2C81B808956053089EEF4EC9A819398B", "50D0AE93B04A21B05717B5DF2B5C1C83");
    }

    public static String encrypt(Object obj, String sm4Key, String sm4Iv) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        String plaintext = new ObjectMapper().writeValueAsString(new PlainObj<Object>(obj));
        String digest = SM3.getDigest(plaintext);
        String s = SM4.encrypt(plaintext + SPLIT + digest, sm4Key, sm4Iv);
        if (s == null) {
            return String.valueOf(obj);
        }
        return s;
    }

    public static <T> T decrypt(String string) {
        return DBUtils.decrypt(string, "2C81B808956053089EEF4EC9A819398B", "50D0AE93B04A21B05717B5DF2B5C1C83");
    }

    public static <T> T decrypt(String string, Class<T> clazz) {
        return DBUtils.decrypt(string, "2C81B808956053089EEF4EC9A819398B", "50D0AE93B04A21B05717B5DF2B5C1C83", clazz);
    }

    public static <T> T decrypt(String string, String sm4Key, String ivKey) {
        if (string == null) {
            return null;
        }
        try {
            String s = SM4.decrypt(string, sm4Key, ivKey);
            if (s == null) {
                return (T)string;
            }
            if (s.equals(string)) {
                if (Pattern.matches("^[A-Za-z0-9]+$", string) && string.length() > 96) {
                    return (T)MESSAGE;
                }
                return (T)string;
            }
            if (s.split(SPLIT).length != 2) {
                return (T)MESSAGE;
            }
            String cipherText = s.split(SPLIT)[0];
            String digest = s.split(SPLIT)[1];
            if (SM3.getDigest(cipherText).equals(digest)) {
                PlainObj encryptObj = (PlainObj)new JsonMapper().readValue(cipherText, PlainObj.class);
                return encryptObj.getPlaintext();
            }
            return (T)MESSAGE;
        }
        catch (Exception e) {
            return (T)string;
        }
    }

    public static <T> T decrypt(String string, String sm4Key, String ivKey, Class<T> clazz) {
        return DBUtils.decrypt(string, sm4Key, ivKey);
    }
}

