/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.asn1.esf;

import ccit.org.bouncycastle.asn1.ASN1EncodableVector;
import ccit.org.bouncycastle.asn1.ASN1Integer;
import ccit.org.bouncycastle.asn1.ASN1Object;
import ccit.org.bouncycastle.asn1.ASN1Primitive;
import ccit.org.bouncycastle.asn1.ASN1Sequence;
import ccit.org.bouncycastle.asn1.ASN1UTCTime;
import ccit.org.bouncycastle.asn1.DERSequence;
import ccit.org.bouncycastle.asn1.x500.X500Name;
import java.math.BigInteger;

public class CrlIdentifier
extends ASN1Object {
    private X500Name crlIssuer;
    private ASN1UTCTime crlIssuedTime;
    private ASN1Integer crlNumber;

    public static CrlIdentifier getInstance(Object object) {
        if (object instanceof CrlIdentifier) {
            return (CrlIdentifier)object;
        }
        if (object != null) {
            return new CrlIdentifier(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CrlIdentifier(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 2 || aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException();
        }
        this.crlIssuer = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.crlIssuedTime = ASN1UTCTime.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 2) {
            this.crlNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public CrlIdentifier(X500Name x500Name, ASN1UTCTime aSN1UTCTime) {
        this(x500Name, aSN1UTCTime, null);
    }

    public CrlIdentifier(X500Name x500Name, ASN1UTCTime aSN1UTCTime, BigInteger bigInteger) {
        this.crlIssuer = x500Name;
        this.crlIssuedTime = aSN1UTCTime;
        if (null != bigInteger) {
            this.crlNumber = new ASN1Integer(bigInteger);
        }
    }

    public X500Name getCrlIssuer() {
        return this.crlIssuer;
    }

    public ASN1UTCTime getCrlIssuedTime() {
        return this.crlIssuedTime;
    }

    public BigInteger getCrlNumber() {
        if (null == this.crlNumber) {
            return null;
        }
        return this.crlNumber.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.crlIssuer.toASN1Primitive());
        aSN1EncodableVector.add(this.crlIssuedTime);
        if (null != this.crlNumber) {
            aSN1EncodableVector.add(this.crlNumber);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

