/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cert.crmf.bc;

import ccit.org.bouncycastle.asn1.crmf.EncryptedValue;
import ccit.org.bouncycastle.cert.crmf.CRMFException;
import ccit.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import ccit.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import ccit.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import ccit.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import ccit.org.bouncycastle.operator.KeyWrapper;
import ccit.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class BcEncryptedValueBuilder
extends EncryptedValueBuilder {
    public BcEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(AsymmetricKeyParameter asymmetricKeyParameter) throws CRMFException, IOException {
        return this.build(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter));
    }
}

