/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cert.crmf.jcajce;

import ccit.org.bouncycastle.asn1.crmf.EncryptedValue;
import ccit.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import ccit.org.bouncycastle.cert.crmf.CRMFException;
import ccit.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import ccit.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import ccit.org.bouncycastle.operator.KeyWrapper;
import ccit.org.bouncycastle.operator.OutputEncryptor;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

