/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cert.dane;

import ccit.org.bouncycastle.cert.X509CertificateHolder;
import ccit.org.bouncycastle.cert.dane.DANEEntry;
import ccit.org.bouncycastle.cert.dane.DANEEntrySelector;
import ccit.org.bouncycastle.cert.dane.DANEEntrySelectorFactory;
import ccit.org.bouncycastle.cert.dane.DANEException;
import ccit.org.bouncycastle.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String string, X509CertificateHolder x509CertificateHolder) throws DANEException {
        return this.createEntry(string, 3, x509CertificateHolder);
    }

    public DANEEntry createEntry(String string, int n, X509CertificateHolder x509CertificateHolder) throws DANEException {
        if (n < 0 || n > 3) {
            throw new DANEException("unknown certificate usage: " + n);
        }
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        byte[] byArray = new byte[]{(byte)n, 0, 0};
        return new DANEEntry(dANEEntrySelector.getDomainName(), byArray, x509CertificateHolder);
    }
}

