/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cert.ocsp;

import ccit.org.bouncycastle.asn1.ASN1GeneralizedTime;
import ccit.org.bouncycastle.asn1.ocsp.RevokedInfo;
import ccit.org.bouncycastle.asn1.x509.CRLReason;
import ccit.org.bouncycastle.cert.ocsp.CertificateStatus;
import ccit.org.bouncycastle.cert.ocsp.OCSPUtils;
import java.util.Date;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo revokedInfo) {
        this.info = revokedInfo;
    }

    public RevokedStatus(Date date) {
        this.info = new RevokedInfo(new ASN1GeneralizedTime(date));
    }

    public RevokedStatus(Date date, int n) {
        this.info = new RevokedInfo(new ASN1GeneralizedTime(date), CRLReason.lookup(n));
    }

    public Date getRevocationTime() {
        return OCSPUtils.extractDate(this.info.getRevocationTime());
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

