/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms;

import ccit.org.bouncycastle.asn1.ASN1Encodable;
import ccit.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import ccit.org.bouncycastle.asn1.ASN1Set;
import ccit.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import ccit.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.OtherRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.RecipientInfo;
import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.cms.AuthAttributesProvider;
import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.CMSReadable;
import ccit.org.bouncycastle.cms.CMSSecureReadable;
import ccit.org.bouncycastle.cms.KEKRecipientInformation;
import ccit.org.bouncycastle.cms.KEMRecipientInformation;
import ccit.org.bouncycastle.cms.KeyAgreeRecipientInformation;
import ccit.org.bouncycastle.cms.KeyTransRecipientInformation;
import ccit.org.bouncycastle.cms.PasswordRecipientInformation;
import ccit.org.bouncycastle.cms.RecipientInformation;
import ccit.org.bouncycastle.cms.RecipientInformationStore;
import ccit.org.bouncycastle.operator.DigestCalculator;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class CMSEnvelopedHelper {
    CMSEnvelopedHelper() {
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        return CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, algorithmIdentifier, cMSSecureReadable, null);
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        ArrayList<RecipientInformation> arrayList = new ArrayList<RecipientInformation>();
        for (int i = 0; i != aSN1Set.size(); ++i) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance(aSN1Set.getObjectAt(i));
            CMSEnvelopedHelper.readRecipientInfo(arrayList, recipientInfo, algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        }
        return new RecipientInformationStore(arrayList);
    }

    private static void readRecipientInfo(List list, RecipientInfo recipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        ASN1Encodable aSN1Encodable = recipientInfo.getInfo();
        if (aSN1Encodable instanceof KeyTransRecipientInfo) {
            list.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        } else if (aSN1Encodable instanceof OtherRecipientInfo) {
            OtherRecipientInfo otherRecipientInfo = OtherRecipientInfo.getInstance(aSN1Encodable);
            if (CMSObjectIdentifiers.id_ori_kem.equals(otherRecipientInfo.getType())) {
                list.add(new KEMRecipientInformation(KEMRecipientInfo.getInstance(otherRecipientInfo.getValue()), algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
            }
        } else if (aSN1Encodable instanceof KEKRecipientInfo) {
            list.add(new KEKRecipientInformation((KEKRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        } else if (aSN1Encodable instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(list, (KeyAgreeRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        } else if (aSN1Encodable instanceof PasswordRecipientInfo) {
            list.add(new PasswordRecipientInformation((PasswordRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        }
    }

    static class CMSAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private final ASN1ObjectIdentifier contentType;
        private CMSReadable readable;

        CMSAuthenticatedSecureReadable(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSReadable cMSReadable) {
            this.algorithm = algorithmIdentifier;
            this.contentType = aSN1ObjectIdentifier;
            this.readable = cMSReadable;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private DigestCalculator digestCalculator;
        private final ASN1ObjectIdentifier contentType;
        private CMSReadable readable;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSReadable cMSReadable) {
            this.digestCalculator = digestCalculator;
            this.contentType = aSN1ObjectIdentifier;
            this.readable = cMSReadable;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this.readable.getInputStream()){

                @Override
                public int read() throws IOException {
                    int n = this.in.read();
                    if (n >= 0) {
                        digestCalculator.getOutputStream().write(n);
                    }
                    return n;
                }

                @Override
                public int read(byte[] byArray, int n, int n2) throws IOException {
                    int n3 = this.in.read(byArray, n, n2);
                    if (n3 >= 0) {
                        digestCalculator.getOutputStream().write(byArray, n, n3);
                    }
                    return n3;
                }
            };
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }
    }

    static class CMSEnvelopedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private final ASN1ObjectIdentifier contentType;
        private CMSReadable readable;

        CMSEnvelopedSecureReadable(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSReadable cMSReadable) {
            this.algorithm = algorithmIdentifier;
            this.contentType = aSN1ObjectIdentifier;
            this.readable = cMSReadable;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }
}

