/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms;

import ccit.org.bouncycastle.asn1.DEROctetString;
import ccit.org.bouncycastle.asn1.cms.KEKIdentifier;
import ccit.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.RecipientInfo;
import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.RecipientInfoGenerator;
import ccit.org.bouncycastle.operator.GenericKey;
import ccit.org.bouncycastle.operator.OperatorException;
import ccit.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

