/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms;

import ccit.org.bouncycastle.asn1.cms.KEKIdentifier;
import ccit.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.cms.AuthAttributesProvider;
import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.CMSSecureReadable;
import ccit.org.bouncycastle.cms.KEKRecipient;
import ccit.org.bouncycastle.cms.KEKRecipientId;
import ccit.org.bouncycastle.cms.Recipient;
import ccit.org.bouncycastle.cms.RecipientInformation;
import ccit.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

