/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms;

import ccit.org.bouncycastle.asn1.ASN1Integer;
import ccit.org.bouncycastle.asn1.DEROctetString;
import ccit.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import ccit.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import ccit.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.OtherRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.RecipientIdentifier;
import ccit.org.bouncycastle.asn1.cms.RecipientInfo;
import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.KEMKeyWrapper;
import ccit.org.bouncycastle.cms.RecipientInfoGenerator;
import ccit.org.bouncycastle.operator.GenericKey;
import ccit.org.bouncycastle.operator.OperatorException;

public abstract class KEMRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final KEMKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KEMRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, KEMKeyWrapper kEMKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = kEMKeyWrapper;
    }

    protected KEMRecipientInfoGenerator(byte[] byArray, KEMKeyWrapper kEMKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = kEMKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new OtherRecipientInfo(CMSObjectIdentifiers.id_ori_kem, new KEMRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(this.wrapper.getEncapsulation()), this.wrapper.getKdfAlgorithmIdentifier(), new ASN1Integer(this.wrapper.getKekLength()), null, this.wrapper.getWrapAlgorithmIdentifier(), new DEROctetString(byArray))));
    }
}

