/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms;

import ccit.org.bouncycastle.asn1.ASN1OctetString;
import ccit.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import ccit.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import ccit.org.bouncycastle.asn1.cms.RecipientIdentifier;
import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.cms.AuthAttributesProvider;
import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.CMSSecureReadable;
import ccit.org.bouncycastle.cms.KEMRecipient;
import ccit.org.bouncycastle.cms.KeyTransRecipientId;
import ccit.org.bouncycastle.cms.Recipient;
import ccit.org.bouncycastle.cms.RecipientInformation;
import ccit.org.bouncycastle.cms.RecipientOperator;

public class KEMRecipientInformation
extends RecipientInformation {
    private KEMRecipientInfo info;

    KEMRecipientInformation(KEMRecipientInfo kEMRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEMRecipientInfo.getKem(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEMRecipientInfo;
        RecipientIdentifier recipientIdentifier = kEMRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KEMRecipient)recipient).getRecipientOperator(new AlgorithmIdentifier(this.keyEncAlg.getAlgorithm(), this.info), this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

